/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkHeader;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import com.couchbase.columnar.client.java.QueryMetrics;
import com.couchbase.columnar.client.java.QueryWarning;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class QueryMetadata {
    private final AnalyticsChunkHeader header;
    private final AnalyticsChunkTrailer trailer;

    QueryMetadata(AnalyticsChunkHeader header, AnalyticsChunkTrailer trailer) {
        this.header = header;
        this.trailer = trailer;
    }

    public String requestId() {
        return this.header.requestId();
    }

    public QueryMetrics metrics() {
        return new QueryMetrics(this.trailer.metrics());
    }

    public List<QueryWarning> warnings() {
        return this.trailer.warnings().map(warnings -> ErrorCodeAndMessage.fromJsonArray((byte[])warnings).stream().map(QueryWarning::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public String toString() {
        return "QueryMetadata{header=" + this.header + ", trailer=" + this.trailer + "}";
    }
}

