/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.config;

import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigDifference;
import com.couchbase.client.vbucket.config.ConfigType;
import com.couchbase.client.vbucket.config.VBucket;
import java.net.URL;
import java.util.List;
import net.spy.memcached.HashAlgorithm;

public class MemcacheConfig
implements Config {
    private int vbucketsCount;
    private final int serversCount;
    private List<String> servers;
    private List<VBucket> vbuckets;
    private final List<String> restEndpoints;

    public MemcacheConfig(int serversCount, List<String> restEndpoints) {
        this.serversCount = serversCount;
        this.restEndpoints = restEndpoints;
    }

    @Override
    public List<String> getRestEndpoints() {
        return this.restEndpoints;
    }

    @Override
    public int getReplicasCount() {
        throw new UnsupportedOperationException("No replica support for cachebuckets");
    }

    @Override
    public int getVbucketsCount() {
        throw new UnsupportedOperationException("No vbucket support for cachebuckets");
    }

    @Override
    public int getServersCount() {
        return this.serversCount;
    }

    @Override
    public String getServer(int serverIndex) {
        if (serverIndex > this.servers.size() - 1) {
            throw new IllegalArgumentException("Server index is out of bounds, index = " + serverIndex + ", servers count = " + this.servers.size());
        }
        return this.servers.get(serverIndex);
    }

    @Override
    public int getVbucketByKey(String key) {
        throw new UnsupportedOperationException("No vbucket support for cachebuckets");
    }

    @Override
    public int getMaster(int vbucketIndex) {
        throw new UnsupportedOperationException("No master/replica support forcache buckets");
    }

    @Override
    public int getReplica(int vbucketIndex, int replicaIndex) {
        throw new UnsupportedOperationException("No replica support for cachebuckets");
    }

    @Override
    public int foundIncorrectMaster(int vbucket, int wrongServer) {
        throw new UnsupportedOperationException("No master check for cache buckets");
    }

    public void setServers(List<String> newServers) {
        this.servers = newServers;
    }

    public void setVbuckets(List<VBucket> newVbuckets) {
        this.vbuckets = newVbuckets;
    }

    @Override
    public List<String> getServers() {
        return this.servers;
    }

    @Override
    public List<VBucket> getVbuckets() {
        return this.vbuckets;
    }

    @Override
    public ConfigDifference compareTo(Config config) {
        ConfigDifference difference = new ConfigDifference();
        if (this.serversCount == config.getServersCount()) {
            difference.setSequenceChanged(false);
            for (int i = 0; i < this.serversCount; ++i) {
                if (this.getServer(i).equals(config.getServer(i))) continue;
                difference.setSequenceChanged(true);
                break;
            }
        } else {
            difference.setSequenceChanged(true);
        }
        if (this.vbucketsCount == config.getVbucketsCount()) {
            int vbucketsChanges = 0;
            for (int i = 0; i < this.vbucketsCount; ++i) {
                vbucketsChanges += this.getMaster(i) == config.getMaster(i) ? 0 : 1;
            }
            difference.setVbucketsChanges(vbucketsChanges);
        } else {
            difference.setVbucketsChanges(-1);
        }
        return difference;
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        throw new UnsupportedOperationException("HashAlgorithm not supported for cache buckets");
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.MEMCACHE;
    }

    @Override
    public List<URL> getCouchServers() {
        throw new UnsupportedOperationException("No couch port for cache buckets");
    }

    @Override
    public boolean isTainted() {
        return false;
    }

    public String toString() {
        return "CacheConfig{vbucketsCount=" + this.vbucketsCount + ", serversCount=" + this.serversCount + ", servers=" + this.servers + ", vbuckets=" + this.vbuckets + ", restEndpoints=" + this.restEndpoints + '}';
    }
}

