/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.context;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.metrics.LoggingMeter;
import com.couchbase.client.core.cnc.metrics.ResponseMetricIdentifier;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.topology.ClusterIdentifier;
import com.couchbase.client.core.topology.ClusterIdentifierUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Stability.Internal
public class CoreTransactionsCounters {
    private final Map<ResponseMetricIdentifier, Counter> transactionsMetrics = new ConcurrentHashMap<ResponseMetricIdentifier, Counter>();
    private final Map<ResponseMetricIdentifier, Counter> attemptMetrics = new ConcurrentHashMap<ResponseMetricIdentifier, Counter>();
    private final Core core;
    private final Meter meter;

    public CoreTransactionsCounters(Core core, Meter meter) {
        this.core = core;
        this.meter = meter;
    }

    public Counter attempts() {
        return this.genericCounter("db.couchbase.transactions.attempts", this.attemptMetrics);
    }

    public Counter transactions() {
        return this.genericCounter("db.couchbase.transactions.total", this.transactionsMetrics);
    }

    private Counter genericCounter(String name, Map<ResponseMetricIdentifier, Counter> metricsMap) {
        ClusterConfig config = this.core.configurationProvider().config();
        ClusterIdentifier clusterIdent = ClusterIdentifierUtil.fromConfig(config);
        boolean isDefaultLoggingMeter = this.core.context().environment().meter() instanceof LoggingMeter;
        ResponseMetricIdentifier rmi = new ResponseMetricIdentifier("transactions", "transaction", null, null, null, null, clusterIdent, isDefaultLoggingMeter);
        return metricsMap.computeIfAbsent(rmi, id -> this.meter.counter(name, id.tags()));
    }
}

