/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class TracingUtils {
    private TracingUtils() {
    }

    public static void setCommonDispatchSpanAttributes(RequestSpan span, @Nullable String localId, @Nullable String localHost, int localPort, @Nullable String remoteHost, int remotePort, @Nullable String operationId) {
        span.lowCardinalityAttribute("net.transport", "IP.TCP");
        if (localId != null) {
            span.attribute("db.couchbase.local_id", localId);
        }
        if (localHost != null) {
            span.attribute("net.host.name", localHost);
        }
        if (localPort != 0) {
            span.attribute("net.host.port", localPort);
        }
        if (remoteHost != null) {
            span.attribute("net.peer.name", remoteHost);
        }
        if (remotePort != 0) {
            span.attribute("net.peer.port", remotePort);
        }
        if (operationId != null) {
            span.attribute("db.couchbase.operation_id", operationId);
        }
    }

    public static void setCommonKVSpanAttributes(RequestSpan span, KeyValueRequest<Response> request) {
        SyncDurabilityRequest syncDurabilityRequest;
        CollectionIdentifier collectionIdentifier = request.collectionIdentifier();
        if (collectionIdentifier != null) {
            span.attribute("db.name", collectionIdentifier.bucket());
            span.attribute("db.couchbase.scope", collectionIdentifier.scope().orElse("_default"));
            span.attribute("db.couchbase.collection", collectionIdentifier.collection().orElse("_default"));
        }
        span.attribute("db.couchbase.document_id", new String(request.key()));
        if (request instanceof SyncDurabilityRequest && (syncDurabilityRequest = (SyncDurabilityRequest)((Object)request)).durabilityLevel() != null) {
            span.lowCardinalityAttribute("db.couchbase.durability", syncDurabilityRequest.durabilityLevel().map(Enum::name).orElse(DurabilityLevel.NONE.name()));
        }
    }

    public static void setNumericOperationId(RequestSpan span, long operationId) {
        span.attribute("db.couchbase.operation_id", operationId);
    }

    public static void setServerDurationAttribute(RequestSpan span, long serverDuration) {
        if (serverDuration > 0L) {
            span.attribute("db.couchbase.server_duration", serverDuration);
        }
    }
}

