/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class CbThrowables {
    private CbThrowables() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <T extends Throwable> Optional<T> findCause(Throwable t, Class<T> type) {
        while (t != null) {
            if (type.isAssignableFrom(t.getClass())) {
                return Optional.of((Throwable)type.cast(t));
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    public static boolean hasCause(Throwable t, Class<? extends Throwable> type) {
        return CbThrowables.findCause(t, type).isPresent();
    }

    public static void throwIfUnchecked(Throwable t) {
        Objects.requireNonNull(t);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public static <T extends Throwable> void throwIfInstanceOf(Throwable t, Class<T> clazz) throws T {
        Objects.requireNonNull(t);
        if (clazz.isInstance(t)) {
            throw (Throwable)clazz.cast(t);
        }
    }

    public static RuntimeException propagate(Throwable t) {
        CbThrowables.throwIfUnchecked(t);
        throw new CouchbaseException(t.getMessage(), t);
    }

    public static String getStackTraceAsString(Throwable t) {
        StringWriter w = new StringWriter();
        t.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    public static void filterStackTrace(Throwable t, Predicate<StackTraceElement> filter) {
        Objects.requireNonNull(t);
        CbThrowables.filterStackTraceRecursive(t, filter, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static void filterStackTraceRecursive(@Nullable Throwable t, Predicate<StackTraceElement> filter, Set<Throwable> seen) {
        if (t == null || !seen.add(t)) {
            return;
        }
        t.setStackTrace((StackTraceElement[])Arrays.stream(t.getStackTrace()).filter(filter).toArray(StackTraceElement[]::new));
        CbThrowables.filterStackTraceRecursive(t.getCause(), filter, seen);
        for (Throwable suppressed : t.getSuppressed()) {
            CbThrowables.filterStackTraceRecursive(suppressed, filter, seen);
        }
    }
}

