/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecordEntry;
import com.couchbase.client.core.transaction.components.CasMode;
import java.util.List;
import java.util.Objects;

@Stability.Internal
public class ActiveTransactionRecords {
    private final List<ActiveTransactionRecordEntry> entries;
    private final String id;
    private final CollectionIdentifier collection;
    private final long casInNanos;
    private final CasMode casMode;

    public ActiveTransactionRecords(String id, CollectionIdentifier collection, long casInNanos, List<ActiveTransactionRecordEntry> entries, CasMode casMode) {
        this.entries = Objects.requireNonNull(entries);
        this.id = Objects.requireNonNull(id);
        this.collection = Objects.requireNonNull(collection);
        this.casInNanos = casInNanos;
        this.casMode = Objects.requireNonNull(casMode);
    }

    public CollectionIdentifier collection() {
        return this.collection;
    }

    public String bucketName() {
        return this.collection.bucket();
    }

    public List<ActiveTransactionRecordEntry> entries() {
        return this.entries;
    }

    public String id() {
        return this.id;
    }

    public long cas() {
        return this.casInNanos;
    }

    public long casInMillis() {
        return this.casInNanos / 1000000L;
    }

    public CasMode casMode() {
        return this.casMode;
    }
}

