/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.PartitionTopology;
import com.couchbase.client.core.topology.TopologyHelper;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;

@Stability.Internal
public class PartitionMap {
    static final PartitionMap ABSENT = new PartitionMap(Collections.emptyList());
    private final List<PartitionTopology> values;

    public PartitionMap(List<PartitionTopology> values) {
        this.values = CbCollections.listCopyOf(values);
    }

    public PartitionTopology get(int partition) {
        try {
            return this.values.get(partition);
        }
        catch (IndexOutOfBoundsException e) {
            return PartitionTopology.ABSENT;
        }
    }

    public List<PartitionTopology> values() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public void forEach(BiConsumer<Integer, PartitionTopology> action) {
        int i = 0;
        for (PartitionTopology entry : this.values) {
            action.accept(i++, entry);
        }
    }

    public Optional<HostAndServicePorts> active(int partition) {
        return this.get(partition).active();
    }

    public List<HostAndServicePorts> availableReplicas(int partition) {
        return this.get(partition).availableReplicas();
    }

    public String toString() {
        TreeMap map = new TreeMap();
        this.forEach((key, value) -> map.put(key, value.toString()));
        return TopologyHelper.compressKeyRuns(map).toString();
    }
}

