/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.BucketTopology;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.JacksonHelper;
import com.couchbase.client.core.util.CbCollections;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@Stability.Internal
abstract class AbstractBucketTopology
implements BucketTopology {
    private final String name;
    private final String uuid;
    private final Set<BucketCapability> capabilities;
    private final List<HostAndServicePorts> nodes;
    private static final ObjectReader bucketCapabilitiesReader = JacksonHelper.reader().withFeatures(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL).forType(new TypeReference<Set<BucketCapability>>(){});

    public AbstractBucketTopology(String name, String uuid, Set<BucketCapability> capabilities, List<HostAndServicePorts> nodes) {
        this.name = Objects.requireNonNull(name);
        this.uuid = Objects.requireNonNull(uuid);
        this.capabilities = Collections.unmodifiableSet(CbCollections.newEnumSet(BucketCapability.class, capabilities));
        this.nodes = Objects.requireNonNull(nodes);
    }

    @Override
    public List<HostAndServicePorts> nodes() {
        return this.nodes;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public Set<BucketCapability> capabilities() {
        return this.capabilities;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static Set<BucketCapability> parseBucketCapabilities(ObjectNode configNode) {
        JsonNode capabilitiesNode = configNode.get("bucketCapabilities");
        if (capabilitiesNode == null) {
            return Collections.emptySet();
        }
        try {
            @Nullable Set result = (Set)bucketCapabilitiesReader.readValue(capabilitiesNode);
            return result.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new CouchbaseException("Failed to parse bucketCapabilities node: " + capabilitiesNode);
        }
    }
}

