/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.kv;

import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.ObserveViaSeqnoResponse;
import com.couchbase.client.core.service.kv.Observe;

class ObserveItem {
    private final int replicated;
    private final int persisted;
    private final boolean persistedActive;

    private ObserveItem(int replicated, int persisted, boolean persistedActive) {
        this.replicated = replicated;
        this.persisted = persisted;
        this.persistedActive = persistedActive;
    }

    public static ObserveItem empty() {
        return new ObserveItem(0, 0, false);
    }

    public static ObserveItem fromMutationToken(MutationToken token, ObserveViaSeqnoResponse response) {
        boolean replicated = response.currentSeqNo() >= token.sequenceNumber();
        boolean persisted = response.lastPersistedSeqNo() >= token.sequenceNumber();
        return new ObserveItem(replicated && !response.active() ? 1 : 0, persisted ? 1 : 0, response.active() && persisted);
    }

    public ObserveItem add(ObserveItem other) {
        return new ObserveItem(this.replicated + other.replicated, this.persisted + other.persisted, this.persistedActive || other.persistedActive);
    }

    public boolean check(Observe.ObservePersistTo persistTo, Observe.ObserveReplicateTo replicateTo) {
        boolean persistDone = false;
        boolean replicateDone = false;
        if (persistTo == Observe.ObservePersistTo.ACTIVE) {
            if (this.persistedActive) {
                persistDone = true;
            }
        } else if (this.persisted >= persistTo.value()) {
            persistDone = true;
        }
        if (this.replicated >= replicateTo.value()) {
            replicateDone = true;
        }
        return persistDone && replicateDone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("persisted ").append(this.persisted);
        if (this.persistedActive) {
            sb.append(" (active)");
        }
        sb.append(", replicated ").append(this.replicated);
        return sb.toString();
    }
}

