/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Address;
import com.couchbase.client.core.deps.org.xbill.DNS.Compression;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSInput;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSOutput;
import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.Record;
import com.couchbase.client.core.deps.org.xbill.DNS.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AAAARecord
extends Record {
    private byte[] address;

    AAAARecord() {
    }

    public AAAARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 28, dclass, ttl);
        if (Address.familyOf(address) != 1 && Address.familyOf(address) != 2) {
            throw new IllegalArgumentException("invalid IPv4/IPv6 address");
        }
        this.address = address.getAddress();
    }

    public AAAARecord(Name name, int dclass, long ttl, byte[] address) {
        super(name, 28, dclass, ttl);
        if (address == null || address.length != 16) {
            throw new IllegalArgumentException("invalid IPv6 address");
        }
        this.address = address;
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.address = in.readByteArray(16);
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.address = st.getAddressBytes(2);
    }

    @Override
    protected String rrToString() {
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(null, this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
        if (addr.getAddress().length == 4) {
            return "::ffff:" + addr.getHostAddress();
        }
        return addr.getHostAddress();
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(this.address);
            }
            return InetAddress.getByAddress(this.name.toString(), this.address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.address);
    }
}

