/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.BucketTopology;
import com.couchbase.client.core.topology.ClusterCapability;
import com.couchbase.client.core.topology.ClusterIdentifier;
import com.couchbase.client.core.topology.ClusterTopology;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.CouchbaseBucketTopology;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.topology.PartitionMap;
import com.couchbase.client.core.topology.PartitionTopology;
import com.couchbase.client.core.topology.PortSelector;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.HostAndPort;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

@Stability.Internal
public final class ClusterTopologyBuilder {
    private TopologyRevision revision = new TopologyRevision(1L, 1L);
    private PortSelector portSelector = PortSelector.TLS;
    private NetworkResolution networkResolution = NetworkResolution.DEFAULT;
    private String clusterName = "fake-cluster";
    private String clusterUuid = "fake-cluster-uuid";
    private String product = "server";
    private Set<ClusterCapability> capabilities = EnumSet.allOf(ClusterCapability.class);
    private final List<HostAndServicePorts> nodes = new ArrayList<HostAndServicePorts>();

    public ClusterTopology build() {
        return this.buildWithOrWithoutBucket(null);
    }

    private ClusterTopology buildWithOrWithoutBucket(@Nullable BucketTopology bucket) {
        return ClusterTopology.of(this.revision, new ClusterIdentifier(this.clusterUuid, this.clusterName, this.product), this.nodes, this.capabilities, this.networkResolution, this.portSelector, bucket);
    }

    public ClusterTopologyBuilder network(NetworkResolution networkResolution) {
        this.networkResolution = Objects.requireNonNull(networkResolution);
        return this;
    }

    public ClusterTopologyBuilder capabilities(Set<ClusterCapability> capabilities) {
        this.capabilities = CbCollections.setCopyOf(capabilities);
        return this;
    }

    public ClusterTopologyBuilder addNode(String hostForExternalConnections, Consumer<NodeBuilder> customizer) {
        NodeBuilder nodeBuilder = new NodeBuilder(hostForExternalConnections);
        customizer.accept(nodeBuilder);
        this.nodes.add(nodeBuilder.build());
        return this;
    }

    public CouchbaseBucketTopologyBuilder couchbaseBucket(String name) {
        return new CouchbaseBucketTopologyBuilder(name);
    }

    @Stability.Internal
    public static class NodeBuilder {
        private final String hostForNetworkConnections;
        private String canonicalHost;
        private Map<ServiceType, Integer> ports = CbCollections.mapOf(ServiceType.MANAGER, 8091);
        @Nullable
        private NodeIdentifier id;
        @Nullable
        private String serverGroup = "Group 1";
        @Nullable
        private HostAndPort ketamaAuthority;

        public NodeBuilder(String hostForNetworkConnections) {
            this.hostForNetworkConnections = Objects.requireNonNull(hostForNetworkConnections);
            this.canonicalHost = Objects.requireNonNull(hostForNetworkConnections);
        }

        public NodeBuilder canonicalHost(String canonicalHost) {
            this.canonicalHost = Objects.requireNonNull(canonicalHost);
            return this;
        }

        public NodeBuilder ketamaAuthority(@Nullable HostAndPort ketamaAuthority) {
            this.ketamaAuthority = ketamaAuthority;
            return this;
        }

        public NodeBuilder ports(Map<ServiceType, Integer> ports) {
            this.ports = CbCollections.mapCopyOf(ports);
            return this;
        }

        public NodeBuilder serverGroup(@Nullable String serverGroup) {
            this.serverGroup = serverGroup;
            return this;
        }

        public HostAndServicePorts build() {
            NodeIdentifier id = this.id != null ? this.id : new NodeIdentifier(this.canonicalHost, 8091, this.hostForNetworkConnections);
            return new HostAndServicePorts(this.hostForNetworkConnections, this.ports, id, this.ketamaAuthority, this.serverGroup, null, null);
        }
    }

    @Stability.Internal
    public class CouchbaseBucketTopologyBuilder {
        private final String bucketName;
        private String bucketUuid = "test-bucket-uuid";
        private int numPartitions = 1024;
        private boolean ephemeral = false;
        private int replicas = 0;
        private Set<BucketCapability> bucketCapabilities = EnumSet.allOf(BucketCapability.class);

        public CouchbaseBucketTopologyBuilder(String bucketName) {
            this.bucketName = Objects.requireNonNull(bucketName);
        }

        public ClusterTopologyWithBucket build() {
            CouchbaseBucketTopology bucket = new CouchbaseBucketTopology(this.bucketName, this.bucketUuid, this.bucketCapabilities, ClusterTopologyBuilder.this.nodes, this.ephemeral, this.replicas, this.buildPartitionMap(), this.buildForwardPartitionMap());
            return ClusterTopologyBuilder.this.buildWithOrWithoutBucket(bucket).requireBucket();
        }

        @Nullable
        private PartitionMap buildForwardPartitionMap() {
            return null;
        }

        public CouchbaseBucketTopologyBuilder numPartitions(int numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        public CouchbaseBucketTopologyBuilder uuid(String uuid) {
            this.bucketUuid = Objects.requireNonNull(uuid);
            return this;
        }

        public CouchbaseBucketTopologyBuilder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        public CouchbaseBucketTopologyBuilder ephemeral(boolean ephemeral) {
            this.ephemeral = ephemeral;
            return this;
        }

        public CouchbaseBucketTopologyBuilder capabilities(Set<BucketCapability> capabilities) {
            this.bucketCapabilities = CbCollections.setCopyOf(capabilities);
            return this;
        }

        private PartitionMap buildPartitionMap() {
            int i;
            ArrayList<PartitionTopology> partitions = new ArrayList<PartitionTopology>();
            ArrayList<HostAndServicePorts> availableReplicas = new ArrayList<HostAndServicePorts>();
            ArrayList<Integer> rawNodeIndexes = new ArrayList<Integer>();
            rawNodeIndexes.add(0);
            for (i = 1; i < ClusterTopologyBuilder.this.nodes.size() && i <= this.replicas; ++i) {
                rawNodeIndexes.add(i);
                availableReplicas.add((HostAndServicePorts)ClusterTopologyBuilder.this.nodes.get(i));
            }
            for (i = 0; i < this.numPartitions; ++i) {
                partitions.add(new PartitionTopology((HostAndServicePorts)ClusterTopologyBuilder.this.nodes.get(0), availableReplicas, rawNodeIndexes));
            }
            return new PartitionMap(partitions);
        }
    }
}

