/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.context;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.topology.ClusterIdentifier;
import com.couchbase.client.core.topology.ClusterIdentifierUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreTransactionsCounters {
    private final Map<TransactionMetricIdentifier, Counter> transactionsMetrics = new ConcurrentHashMap<TransactionMetricIdentifier, Counter>();
    private final Map<TransactionMetricIdentifier, Counter> attemptMetrics = new ConcurrentHashMap<TransactionMetricIdentifier, Counter>();
    private final Core core;
    private final Meter meter;

    public CoreTransactionsCounters(Core core, Meter meter) {
        this.core = core;
        this.meter = meter;
    }

    public Counter attempts() {
        return this.genericCounter("db.couchbase.transactions.attempts", this.attemptMetrics);
    }

    public Counter transactions() {
        return this.genericCounter("db.couchbase.transactions.total", this.transactionsMetrics);
    }

    private Counter genericCounter(String name, Map<TransactionMetricIdentifier, Counter> metricsMap) {
        ClusterConfig config = this.core.configurationProvider().config();
        ClusterIdentifier clusterIdent = ClusterIdentifierUtil.fromConfig(config);
        return metricsMap.computeIfAbsent(new TransactionMetricIdentifier(clusterIdent), id -> {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("db.system", "couchbase");
            if (((TransactionMetricIdentifier)id).clusterName != null) {
                tags.put("db.couchbase.cluster_name", ((TransactionMetricIdentifier)id).clusterName);
            }
            if (((TransactionMetricIdentifier)id).clusterUuid != null) {
                tags.put("db.couchbase.cluster_uuid", ((TransactionMetricIdentifier)id).clusterUuid);
            }
            return this.meter.counter(name, tags);
        });
    }

    @Stability.Internal
    public static class TransactionMetricIdentifier {
        @Nullable
        private final String clusterName;
        @Nullable
        private final String clusterUuid;

        TransactionMetricIdentifier(@Nullable ClusterIdentifier clusterIdent) {
            this.clusterName = clusterIdent == null ? null : clusterIdent.clusterName();
            this.clusterUuid = clusterIdent == null ? null : clusterIdent.clusterUuid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetricIdentifier that = (TransactionMetricIdentifier)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.clusterUuid, that.clusterUuid);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.clusterUuid);
        }
    }
}

