/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.manager;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.TargetedRequest;
import com.couchbase.client.core.msg.manager.BaseManagerRequest;
import com.couchbase.client.core.msg.manager.BucketConfigResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.topology.NodeIdentifier;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;

public class BucketConfigRequest
extends BaseManagerRequest<BucketConfigResponse>
implements TargetedRequest {
    private static final String PATH = "/pools/default/b/{}";
    private final String bucketName;
    private final Authenticator authenticator;
    private final NodeIdentifier target;

    public BucketConfigRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, String bucketName, Authenticator authenticator, NodeIdentifier target) {
        super(timeout, ctx, retryStrategy);
        this.bucketName = bucketName;
        this.authenticator = authenticator;
        this.target = target;
    }

    @Override
    public FullHttpRequest encode() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, CoreHttpPath.formatPath(PATH, this.bucketName));
        this.authenticator.authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public NodeIdentifier target() {
        return this.target;
    }

    @Override
    public BucketConfigResponse decode(HttpResponse response, byte[] content) {
        return new BucketConfigResponse(HttpProtocol.decodeStatus(response.status()), content);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("bucket", RedactableArgument.redactMeta(this.bucketName));
        if (this.target != null) {
            ctx.put("target", RedactableArgument.redactSystem(this.target));
        }
        return ctx;
    }
}

