/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public interface NetworkSelector {
    public static final NetworkSelector DEFAULT = NetworkSelector.create(NetworkResolution.DEFAULT, Collections.emptySet());
    public static final NetworkSelector EXTERNAL = NetworkSelector.create(NetworkResolution.EXTERNAL, Collections.emptySet());

    public Optional<NetworkResolution> selectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> var1);

    public static NetworkSelector create(final NetworkResolution network, Set<SeedNode> seedNodes) {
        if (network.equals(NetworkResolution.AUTO)) {
            return new AutoNetworkSelector(seedNodes);
        }
        return new NetworkSelector(){

            @Override
            public Optional<NetworkResolution> selectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> nodes) {
                return Optional.of(network);
            }

            public String toString() {
                return network.name();
            }
        };
    }

    public static NetworkSelector autoDetect(Set<SeedNode> seedNodes) {
        return NetworkSelector.create(NetworkResolution.AUTO, seedNodes);
    }

    public static class AutoNetworkSelector
    implements NetworkSelector {
        private final Set<SeedNode> seedNodes;
        private @Nullable Optional<NetworkResolution> cachedResult;

        public AutoNetworkSelector(Set<SeedNode> seedNodes) {
            this.seedNodes = CbCollections.setCopyOf(seedNodes);
        }

        @Override
        public synchronized Optional<NetworkResolution> selectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> nodes) {
            if (this.cachedResult == null) {
                this.cachedResult = this.doSelectNetwork(nodes);
            }
            return this.cachedResult;
        }

        public synchronized String toString() {
            String network = this.cachedResult == null ? "<TBD>" : this.cachedResult.map(NetworkResolution::name).orElse("no match -> default");
            return "auto(" + network + "; seedNodes=" + this.seedNodes + ")";
        }

        private Optional<NetworkResolution> doSelectNetwork(List<Map<NetworkResolution, HostAndServicePorts>> nodes) {
            for (Map<NetworkResolution, HostAndServicePorts> node : nodes) {
                for (Map.Entry<NetworkResolution, HostAndServicePorts> entry : node.entrySet()) {
                    for (SeedNode seedNode : this.seedNodes) {
                        if (!entry.getValue().matches(seedNode)) continue;
                        return Optional.of(entry.getKey());
                    }
                }
            }
            return Optional.empty();
        }
    }
}

