/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.collector;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

class FixedBucketLongHistogram {
    private final long[] bucketUpperBoundInclusive;
    private final LongAdder[] buckets;

    public FixedBucketLongHistogram(List<Long> bucketUpperBoundInclusive) {
        this.bucketUpperBoundInclusive = FixedBucketLongHistogram.requireSortedAndDistinct(FixedBucketLongHistogram.toPrimitiveLongArray(bucketUpperBoundInclusive));
        this.buckets = new LongAdder[bucketUpperBoundInclusive.size()];
        Arrays.setAll(this.buckets, i -> new LongAdder());
    }

    private static long[] toPrimitiveLongArray(Collection<Long> longs) {
        return longs.stream().mapToLong(Long::longValue).toArray();
    }

    private static long[] requireSortedAndDistinct(long[] array) {
        long[] sortedAndDistinct = Arrays.stream(array).sorted().distinct().toArray();
        if (!Arrays.equals(array, sortedAndDistinct)) {
            throw new IllegalArgumentException("Array has duplicate elements or is not sorted: " + Arrays.toString(array));
        }
        return array;
    }

    public void record(long value) {
        int len = this.bucketUpperBoundInclusive.length;
        for (int i = 0; i < len; ++i) {
            if (value > this.bucketUpperBoundInclusive[i]) continue;
            this.buckets[i].increment();
            return;
        }
    }

    public long[] report() {
        long[] result = new long[this.buckets.length];
        int len = this.buckets.length;
        for (int i = 0; i < len; ++i) {
            result[i] = this.buckets[i].sumThenReset();
        }
        return result;
    }
}

