/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryProfile;
import com.couchbase.client.core.api.query.CoreQueryScanConsistency;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.transaction.config.CoreSingleQueryTransactionOptions;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreQueryOptionsTransactions
implements CoreQueryOptions {
    @Nullable
    private final CoreQueryOptions original;
    private Map<String, JsonNode> raw;
    private Boolean metrics;
    private CoreSingleQueryTransactionOptions asTransactionOptions;
    private Map<QueryOptionsParameter, ParameterPassthrough> passthroughSettings;

    public CoreQueryOptionsTransactions() {
        this.original = null;
    }

    public CoreQueryOptionsTransactions(@Nullable CoreQueryOptions original) {
        this.original = original;
    }

    public CoreQueryOptionsTransactions raw(String key, JsonNode value) {
        Validators.notNullOrEmpty(key, "Key");
        if (this.raw == null) {
            this.raw = new HashMap<String, JsonNode>();
        }
        this.raw.put(key, value);
        return this;
    }

    public CoreQueryOptionsTransactions metrics(boolean metrics) {
        this.metrics = metrics;
        return this;
    }

    public CoreQueryOptionsTransactions set(QueryOptionsParameter param, ParameterPassthrough passthrough) {
        if (this.passthroughSettings == null) {
            this.passthroughSettings = new HashMap<QueryOptionsParameter, ParameterPassthrough>();
        }
        this.passthroughSettings.put(param, passthrough);
        return this;
    }

    public CoreQueryOptionsTransactions put(String key, JsonNode value) {
        return this.raw(key, value);
    }

    @Override
    public boolean adhoc() {
        return this.original == null ? true : this.original.adhoc();
    }

    @Override
    public String clientContextId() {
        return this.original == null ? null : this.original.clientContextId();
    }

    @Override
    public CoreMutationState consistentWith() {
        return this.original == null ? null : this.original.consistentWith();
    }

    @Override
    public Integer maxParallelism() {
        return this.original == null ? null : this.original.maxParallelism();
    }

    private ParameterPassthrough passthroughFor(QueryOptionsParameter param) {
        if (this.passthroughSettings == null) {
            return ParameterPassthrough.DEFAULT;
        }
        ParameterPassthrough ret = this.passthroughSettings.get((Object)param);
        return ret == null ? ParameterPassthrough.DEFAULT : ret;
    }

    @Override
    public boolean metrics() {
        switch (this.passthroughFor(QueryOptionsParameter.METRICS)) {
            case ALWAYS_SHADOWED: {
                return this.metrics;
            }
        }
        return this.metrics != null ? this.metrics : this.original != null && this.original.metrics();
    }

    @Override
    public ObjectNode namedParameters() {
        return this.original == null ? null : this.original.namedParameters();
    }

    @Override
    public Integer pipelineBatch() {
        return this.original == null ? null : this.original.pipelineBatch();
    }

    @Override
    public Integer pipelineCap() {
        return this.original == null ? null : this.original.pipelineCap();
    }

    @Override
    public ArrayNode positionalParameters() {
        return this.original == null ? null : this.original.positionalParameters();
    }

    @Override
    public CoreQueryProfile profile() {
        return this.original == null ? CoreQueryProfile.OFF : this.original.profile();
    }

    @Override
    public JsonNode raw() {
        switch (this.passthroughFor(QueryOptionsParameter.RAW)) {
            case ALWAYS_SHADOWED: {
                if (this.raw == null) {
                    return null;
                }
                ObjectNode out = Mapper.createObjectNode();
                this.raw.forEach(out::set);
                return out;
            }
        }
        if (this.original != null && this.original.raw() != null) {
            ObjectNode out = Mapper.createObjectNode();
            JsonNode origRaw = this.original.raw();
            origRaw.fieldNames().forEachRemaining(fieldName -> out.set((String)fieldName, origRaw.get((String)fieldName)));
            if (this.raw != null) {
                this.raw.forEach(out::set);
            }
            return out;
        }
        if (this.raw == null) {
            return null;
        }
        ObjectNode out = Mapper.createObjectNode();
        this.raw.forEach(out::set);
        return out;
    }

    @Override
    public boolean readonly() {
        return this.original == null ? false : this.original.readonly();
    }

    @Override
    public Duration scanWait() {
        return this.original == null ? null : this.original.scanWait();
    }

    @Override
    public Integer scanCap() {
        return this.original == null ? null : this.original.scanCap();
    }

    @Override
    public CoreQueryScanConsistency scanConsistency() {
        return this.original == null ? null : this.original.scanConsistency();
    }

    @Override
    public boolean flexIndex() {
        return this.original == null ? false : this.original.flexIndex();
    }

    @Override
    public Boolean preserveExpiry() {
        return this.original == null ? null : this.original.preserveExpiry();
    }

    @Override
    public Boolean useReplica() {
        return this.original == null ? null : this.original.useReplica();
    }

    @Override
    public CoreSingleQueryTransactionOptions asTransactionOptions() {
        switch (this.passthroughFor(QueryOptionsParameter.AS_TRANSACTION_OPTIONS)) {
            case ALWAYS_SHADOWED: {
                return this.asTransactionOptions;
            }
        }
        if (this.asTransactionOptions != null) {
            throw new IllegalStateException("Internal bug - should not reach here");
        }
        return this.original == null ? null : this.original.asTransactionOptions();
    }

    @Override
    public CoreCommonOptions commonOptions() {
        return this.original == null ? CoreCommonOptions.DEFAULT : this.original.commonOptions();
    }

    public static enum ParameterPassthrough {
        DEFAULT,
        ALWAYS_SHADOWED;

    }

    public static enum QueryOptionsParameter {
        RAW,
        METRICS,
        AS_TRANSACTION_OPTIONS;

    }
}

