/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.Timer;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.DefaultEventBus;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.LoggingEventConsumer;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.OrphanReporter;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.cnc.events.config.HighIdleHttpConnectionTimeoutConfiguredEvent;
import com.couchbase.client.core.cnc.events.config.InsecureSecurityConfigDetectedEvent;
import com.couchbase.client.core.cnc.metrics.LoggingMeter;
import com.couchbase.client.core.cnc.metrics.NoopMeter;
import com.couchbase.client.core.cnc.tracing.NoopRequestTracer;
import com.couchbase.client.core.cnc.tracing.ThresholdLoggingTracer;
import com.couchbase.client.core.deps.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.env.ConfigurationProfile;
import com.couchbase.client.core.env.CouchbaseThreadFactory;
import com.couchbase.client.core.env.IoConfig;
import com.couchbase.client.core.env.IoEnvironment;
import com.couchbase.client.core.env.LoggerConfig;
import com.couchbase.client.core.env.LoggingMeterConfig;
import com.couchbase.client.core.env.OrphanReporterConfig;
import com.couchbase.client.core.env.OwnedOrExternal;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.RequestCallback;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.env.SystemPropertyPropertyLoader;
import com.couchbase.client.core.env.ThresholdLoggingTracerConfig;
import com.couchbase.client.core.env.ThresholdRequestTracerConfig;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.env.UserAgent;
import com.couchbase.client.core.env.VersionAndGitHash;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.AbstractPooledEndpointServiceConfig;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.forwards.CoreTransactionsSupportedExtensions;
import com.couchbase.client.core.transaction.util.CoreTransactionsSchedulers;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.Nullable;

public class CoreEnvironment
implements ReactorOps,
AutoCloseable {
    private static final VersionAndGitHash coreVersion = VersionAndGitHash.from(Core.class);
    private static final String CORE_AGENT_TITLE = "java-core";
    public static final long DEFAULT_MAX_NUM_REQUESTS_IN_RETRY = 32768L;
    private static final ServiceLoader<ConfigurationProfile> environmentProfileLoader = ServiceLoader.load(ConfigurationProfile.class);
    private static final RetryStrategy DEFAULT_RETRY_STRATEGY = BestEffortRetryStrategy.INSTANCE;
    private final UserAgent userAgent;
    private final OwnedOrExternal<EventBus> eventBus;
    private final Timer timer;
    private final IoEnvironment ioEnvironment;
    private final IoConfig ioConfig;
    private final CompressionConfig compressionConfig;
    private final SecurityConfig securityConfig;
    private final TimeoutConfig timeoutConfig;
    private final OrphanReporterConfig orphanReporterConfig;
    private final ThresholdLoggingTracerConfig thresholdLoggingTracerConfig;
    private final LoggingMeterConfig loggingMeterConfig;
    private final OwnedOrExternal<RequestTracer> requestTracer;
    private final OwnedOrExternal<Meter> meter;
    private final LoggerConfig loggerConfig;
    private final RetryStrategy retryStrategy;
    private final OwnedOrExternal<Scheduler> scheduler;
    private final OwnedOrExternal<Executor> executor;
    @Nullable
    private final Supplier<Scheduler> userScheduler;
    private final int schedulerThreadCount;
    private final OrphanReporter orphanReporter;
    private final long maxNumRequestsInRetry;
    private final List<RequestCallback> requestCallbacks;
    private final CoreTransactionsConfig transactionsConfig;
    private final Set<String> appliedProfiles;
    private final CoreTransactionsSchedulers transactionsSchedulers = new CoreTransactionsSchedulers();
    @Nullable
    private final String preferredServerGroup;

    public static CoreEnvironment create() {
        return CoreEnvironment.builder().build();
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    protected CoreEnvironment(Builder<?> builder) {
        this.userAgent = this.defaultUserAgent();
        this.maxNumRequestsInRetry = ((Builder)builder).maxNumRequestsInRetry;
        this.schedulerThreadCount = ((Builder)builder).schedulerThreadCount;
        this.scheduler = Optional.ofNullable(((Builder)builder).scheduler).orElse(OwnedOrExternal.owned(Schedulers.newParallel((String)"cb-comp", (int)this.schedulerThreadCount, (boolean)true)));
        this.userScheduler = ((Builder)builder).userScheduler;
        String executorMaxThreadCountRaw = System.getProperty("com.couchbase.protostellar.executorMaxThreadCount");
        int maxThreadCount = Runtime.getRuntime().availableProcessors();
        if (executorMaxThreadCountRaw != null) {
            maxThreadCount = Integer.parseInt(executorMaxThreadCountRaw);
        }
        this.executor = OwnedOrExternal.owned(new ThreadPoolExecutor(0, maxThreadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new CouchbaseThreadFactory("cb-exec")));
        this.eventBus = Optional.ofNullable(((Builder)builder).eventBus).orElse(OwnedOrExternal.owned(DefaultEventBus.create(this.scheduler.get())));
        this.timer = Timer.createAndStart(this.maxNumRequestsInRetry, ((Builder)builder).ioConfig.timerConfig().build());
        this.securityConfig = ((Builder)builder).securityConfig.build();
        this.ioEnvironment = ((Builder)builder).ioEnvironment.build();
        this.ioConfig = ((Builder)builder).ioConfig.build();
        this.compressionConfig = ((Builder)builder).compressionConfig.build();
        this.timeoutConfig = ((Builder)builder).timeoutConfig.build();
        this.retryStrategy = Optional.ofNullable(((Builder)builder).retryStrategy).orElse(DEFAULT_RETRY_STRATEGY);
        this.loggerConfig = ((Builder)builder).loggerConfig.build();
        this.orphanReporterConfig = ((Builder)builder).orphanReporterConfig.build();
        this.thresholdLoggingTracerConfig = ((Builder)builder).thresholdLoggingTracerConfig.build();
        this.loggingMeterConfig = ((Builder)builder).loggingMeterConfig.build();
        this.appliedProfiles = ((Builder)builder).appliedProfiles;
        CoreTransactionsConfig coreTransactionsConfig = this.transactionsConfig = builder.transactionsConfig != null ? builder.transactionsConfig : CoreTransactionsConfig.createDefault(CoreTransactionsSupportedExtensions.ALL);
        if (this.eventBus.isOwned()) {
            this.eventBus.get().start().block();
        }
        this.eventBus.get().subscribe(LoggingEventConsumer.create(this.loggerConfig()));
        this.requestTracer = Optional.ofNullable(((Builder)builder).requestTracer).orElse(OwnedOrExternal.owned(this.thresholdLoggingTracerConfig.enabled() ? ThresholdLoggingTracer.create(this.eventBus.get(), this.thresholdLoggingTracerConfig) : NoopRequestTracer.INSTANCE));
        if (this.requestTracer.isOwned()) {
            this.requestTracer.get().start().block();
        }
        this.meter = Optional.ofNullable(((Builder)builder).meter).orElse(OwnedOrExternal.owned(this.loggingMeterConfig.enabled() ? LoggingMeter.create(this.eventBus.get(), this.loggingMeterConfig) : NoopMeter.INSTANCE));
        if (this.meter.isOwned()) {
            this.meter.get().start().block();
        }
        this.orphanReporter = new OrphanReporter(this.eventBus.get(), this.orphanReporterConfig);
        this.orphanReporter.start().block();
        if (this.ioConfig.idleHttpConnectionTimeout().toMillis() > AbstractPooledEndpointServiceConfig.DEFAULT_IDLE_TIME.toMillis()) {
            this.eventBus.get().publish(new HighIdleHttpConnectionTimeoutConfiguredEvent());
        }
        this.requestCallbacks = Collections.unmodifiableList(((Builder)builder).requestCallbacks);
        this.preferredServerGroup = ((Builder)builder).preferredServerGroup;
        this.checkInsecureTlsConfig();
    }

    private void checkInsecureTlsConfig() {
        if (this.securityConfig.tlsEnabled()) {
            boolean validateHosts = this.securityConfig.hostnameVerificationEnabled();
            boolean insecureTrustManager = this.securityConfig.trustManagerFactory() instanceof InsecureTrustManagerFactory;
            if (!validateHosts || insecureTrustManager) {
                this.eventBus.get().publish(new InsecureSecurityConfigDetectedEvent(validateHosts, insecureTrustManager));
            }
        }
    }

    private UserAgent defaultUserAgent() {
        try {
            String os = String.join((CharSequence)" ", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
            String platform = String.join((CharSequence)" ", System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"));
            return new UserAgent(this.defaultAgentTitle(), this.clientVersion(), Optional.of(os), Optional.of(platform));
        }
        catch (Throwable t) {
            return new UserAgent(this.defaultAgentTitle(), this.clientVersion(), Optional.empty(), Optional.empty());
        }
    }

    protected String defaultAgentTitle() {
        return CORE_AGENT_TITLE;
    }

    protected VersionAndGitHash clientVersionAndGitHash() {
        return VersionAndGitHash.UNKNOWN;
    }

    public Optional<String> clientHash() {
        return Optional.of(this.clientVersionAndGitHash().gitHash());
    }

    public Optional<String> coreHash() {
        return Optional.of(coreVersion.gitHash());
    }

    public Optional<String> clientVersion() {
        return Optional.of(this.clientVersionAndGitHash().version());
    }

    public Optional<String> coreVersion() {
        return Optional.of(coreVersion.version());
    }

    public UserAgent userAgent() {
        return this.userAgent;
    }

    public EventBus eventBus() {
        return this.eventBus.get();
    }

    public IoEnvironment ioEnvironment() {
        return this.ioEnvironment;
    }

    public IoConfig ioConfig() {
        return this.ioConfig;
    }

    public TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public SecurityConfig securityConfig() {
        return this.securityConfig;
    }

    public CompressionConfig compressionConfig() {
        return this.compressionConfig;
    }

    public LoggerConfig loggerConfig() {
        return this.loggerConfig;
    }

    public Scheduler scheduler() {
        return this.scheduler.get();
    }

    @Stability.Internal
    @Nullable
    public Supplier<Scheduler> userScheduler() {
        return this.userScheduler;
    }

    @Override
    @Stability.Internal
    public <T> Mono<T> publishOnUserScheduler(Mono<T> mono) {
        return this.userScheduler == null ? mono : Mono.defer(() -> mono.publishOn(this.userScheduler.get()));
    }

    @Override
    @Stability.Internal
    public <T> Flux<T> publishOnUserScheduler(Flux<T> flux) {
        return this.userScheduler == null ? flux : Flux.defer(() -> flux.publishOn(this.userScheduler.get()));
    }

    @Stability.Internal
    public Executor executor() {
        return this.executor.get();
    }

    @Stability.Volatile
    @Deprecated
    public RequestTracer requestTracer() {
        return this.requestTracer.get();
    }

    @Stability.Volatile
    public Meter meter() {
        return this.meter.get();
    }

    @Stability.Internal
    public List<RequestCallback> requestCallbacks() {
        return this.requestCallbacks;
    }

    public Timer timer() {
        return this.timer;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public OrphanReporter orphanReporter() {
        return this.orphanReporter;
    }

    public long maxNumRequestsInRetry() {
        return this.maxNumRequestsInRetry;
    }

    @Stability.Volatile
    public CoreTransactionsConfig transactionsConfig() {
        return this.transactionsConfig;
    }

    @Stability.Volatile
    public CoreTransactionsSchedulers transactionsSchedulers() {
        return this.transactionsSchedulers;
    }

    @Nullable
    public String preferredServerGroup() {
        return this.preferredServerGroup;
    }

    public CompletableFuture<Void> shutdownAsync() {
        return this.shutdownAsync(this.timeoutConfig.disconnectTimeout());
    }

    public CompletableFuture<Void> shutdownAsync(Duration timeout) {
        return this.shutdownReactive(timeout).toFuture();
    }

    public Mono<Void> shutdownReactive() {
        return this.shutdownReactive(this.timeoutConfig.disconnectTimeout());
    }

    public Mono<Void> shutdownReactive(Duration timeout) {
        return Mono.defer(() -> this.eventBus.isOwned() ? this.eventBus.get().stop(timeout) : Mono.empty()).then(Mono.defer(() -> {
            this.timer.stop();
            return Mono.empty();
        })).then(this.ioEnvironment.shutdown(timeout)).then(Mono.defer(() -> {
            if (this.requestTracer.isOwned()) {
                return this.requestTracer.get().stop(timeout);
            }
            return Mono.empty();
        })).then(Mono.defer(() -> {
            if (this.meter.isOwned()) {
                return this.meter.get().stop(timeout);
            }
            return Mono.empty();
        })).then(Mono.defer(this.orphanReporter::stop)).then(Mono.defer(() -> {
            if (this.scheduler.isOwned()) {
                this.scheduler.get().dispose();
            }
            return Mono.empty();
        })).then(Mono.defer(() -> {
            if (this.executor.isOwned()) {
                if (this.executor.get() instanceof ThreadPoolExecutor) {
                    ((ThreadPoolExecutor)this.executor.get()).shutdown();
                } else {
                    throw new IllegalStateException("Unknown but owned executor type");
                }
            }
            return Mono.empty();
        })).then(Mono.fromRunnable(() -> this.transactionsSchedulers().shutdown())).then().timeout(timeout);
    }

    public void shutdown(Duration timeout) {
        this.shutdownReactive(timeout).block();
    }

    public void shutdown() {
        this.shutdown(this.timeoutConfig.disconnectTimeout());
    }

    public String exportAsString(Context.ExportFormat format) {
        LinkedHashMap<String, Object> input = new LinkedHashMap<String, Object>();
        input.put("clientVersion", this.clientVersion().orElse(null));
        input.put("clientGitHash", this.clientHash().orElse(null));
        input.put("coreVersion", this.coreVersion().orElse(null));
        input.put("coreGitHash", this.coreHash().orElse(null));
        input.put("userAgent", this.userAgent.formattedLong());
        input.put("maxNumRequestsInRetry", this.maxNumRequestsInRetry);
        input.put("ioEnvironment", this.ioEnvironment.exportAsMap());
        input.put("ioConfig", this.ioConfig.exportAsMap());
        input.put("compressionConfig", this.compressionConfig.exportAsMap());
        input.put("securityConfig", this.securityConfig.exportAsMap());
        input.put("timeoutConfig", this.timeoutConfig.exportAsMap());
        input.put("loggerConfig", this.loggerConfig.exportAsMap());
        input.put("orphanReporterConfig", this.orphanReporterConfig.exportAsMap());
        input.put("thresholdLoggingTracerConfig", this.thresholdLoggingTracerConfig.exportAsMap());
        input.put("loggingMeterConfig", this.loggingMeterConfig.exportAsMap());
        input.put("retryStrategy", this.retryStrategy.getClass().getSimpleName());
        input.put("requestTracer", this.requestTracer.get().toString());
        input.put("meter", this.meter.get().getClass().getSimpleName());
        input.put("numRequestCallbacks", this.requestCallbacks.size());
        input.put("scheduler", this.scheduler.get().getClass().getSimpleName());
        input.put("schedulerThreadCount", this.schedulerThreadCount);
        input.put("transactionsConfig", this.transactionsConfig.exportAsMap());
        if (!this.appliedProfiles.isEmpty()) {
            input.put("profiles", this.appliedProfiles);
        }
        input.put("preferredServerGroup", RedactableArgument.redactMeta(this.preferredServerGroup));
        return (String)format.apply(input);
    }

    public String toString() {
        return this.exportAsString(Context.ExportFormat.STRING);
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private static Set<String> registeredProfileNames() {
        HashSet<String> names = new HashSet<String>();
        for (ConfigurationProfile profile : environmentProfileLoader) {
            names.add(profile.name());
        }
        return names;
    }

    public static class Builder<SELF extends Builder<SELF>> {
        private IoEnvironment.Builder ioEnvironment = new IoEnvironment.Builder();
        private IoConfig.Builder ioConfig = new IoConfig.Builder();
        private CompressionConfig.Builder compressionConfig = new CompressionConfig.Builder();
        private SecurityConfig.Builder securityConfig = new SecurityConfig.Builder();
        private TimeoutConfig.Builder timeoutConfig = new TimeoutConfig.Builder();
        private LoggerConfig.Builder loggerConfig = new LoggerConfig.Builder();
        private OrphanReporterConfig.Builder orphanReporterConfig = new OrphanReporterConfig.Builder();
        private ThresholdLoggingTracerConfig.Builder thresholdLoggingTracerConfig = new ThresholdLoggingTracerConfig.Builder();
        private LoggingMeterConfig.Builder loggingMeterConfig = new LoggingMeterConfig.Builder();
        private OwnedOrExternal<EventBus> eventBus = null;
        private OwnedOrExternal<Scheduler> scheduler = null;
        private Supplier<Scheduler> userScheduler = null;
        private int schedulerThreadCount = Schedulers.DEFAULT_POOL_SIZE;
        private OwnedOrExternal<RequestTracer> requestTracer = null;
        private OwnedOrExternal<Meter> meter = null;
        private RetryStrategy retryStrategy = null;
        private long maxNumRequestsInRetry = 32768L;
        private final List<RequestCallback> requestCallbacks = new ArrayList<RequestCallback>();
        protected CoreTransactionsConfig transactionsConfig = null;
        private String preferredServerGroup = null;
        private final Set<String> appliedProfiles = new LinkedHashSet<String>();

        protected Builder() {
        }

        public SELF ioEnvironment(Consumer<IoEnvironment.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.ioEnvironment);
            return this.self();
        }

        public SELF ioConfig(Consumer<IoConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.ioConfig);
            return this.self();
        }

        public SELF compressionConfig(Consumer<CompressionConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.compressionConfig);
            return this.self();
        }

        public SELF securityConfig(Consumer<SecurityConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.securityConfig);
            return this.self();
        }

        public SELF timeoutConfig(Consumer<TimeoutConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.timeoutConfig);
            return this.self();
        }

        public SELF loggerConfig(Consumer<LoggerConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.loggerConfig);
            return this.self();
        }

        public SELF orphanReporterConfig(Consumer<OrphanReporterConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.orphanReporterConfig);
            return this.self();
        }

        public SELF thresholdLoggingTracerConfig(Consumer<ThresholdLoggingTracerConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.thresholdLoggingTracerConfig);
            return this.self();
        }

        public SELF loggingMeterConfig(Consumer<LoggingMeterConfig.Builder> builderConsumer) {
            Validators.notNull(builderConsumer, "BuilderConsumer").accept(this.loggingMeterConfig);
            return this.self();
        }

        protected SELF self() {
            return (SELF)this;
        }

        public SELF maxNumRequestsInRetry(long maxNumRequestsInRetry) {
            if (maxNumRequestsInRetry < 0L) {
                throw InvalidArgumentException.fromMessage("maxNumRequestsInRetry cannot be negative");
            }
            this.maxNumRequestsInRetry = maxNumRequestsInRetry;
            return this.self();
        }

        public SELF load(PropertyLoader<Builder> loader) {
            Validators.notNull(loader, "PropertyLoader");
            loader.load(this);
            return this.self();
        }

        @Deprecated
        public SELF ioEnvironment(IoEnvironment.Builder ioEnvironment) {
            this.ioEnvironment = Validators.notNull(ioEnvironment, "IoEnvironment");
            return this.self();
        }

        @Deprecated
        public IoEnvironment.Builder ioEnvironment() {
            return this.ioEnvironmentConfig();
        }

        public IoEnvironment.Builder ioEnvironmentConfig() {
            return this.ioEnvironment;
        }

        @Deprecated
        public SELF ioConfig(IoConfig.Builder ioConfig) {
            this.ioConfig = Validators.notNull(ioConfig, "IoConfig");
            return this.self();
        }

        public IoConfig.Builder ioConfig() {
            return this.ioConfig;
        }

        @Deprecated
        public SELF orphanReporterConfig(OrphanReporterConfig.Builder orphanReporterConfig) {
            this.orphanReporterConfig = Validators.notNull(orphanReporterConfig, "OrphanReporterConfig");
            return this.self();
        }

        public OrphanReporterConfig.Builder orphanReporterConfig() {
            return this.orphanReporterConfig;
        }

        @Deprecated
        public SELF loggingMeterConfig(LoggingMeterConfig.Builder loggingMeterConfig) {
            this.loggingMeterConfig = Validators.notNull(loggingMeterConfig, "LoggingMeterConfig");
            return this.self();
        }

        public LoggingMeterConfig.Builder loggingMeterConfig() {
            return this.loggingMeterConfig;
        }

        @Deprecated
        public SELF thresholdRequestTracerConfig(ThresholdRequestTracerConfig.Builder thresholdRequestTracerConfig) {
            this.thresholdLoggingTracerConfig = Validators.notNull(thresholdRequestTracerConfig, "ThresholdRequestTracerConfig").toNewBuillder();
            return this.self();
        }

        @Deprecated
        public ThresholdRequestTracerConfig.Builder thresholdRequestTracerConfig() {
            return ThresholdRequestTracerConfig.Builder.fromNewBuilder(this.thresholdLoggingTracerConfig);
        }

        @Deprecated
        public SELF thresholdLoggingTracerConfig(ThresholdLoggingTracerConfig.Builder thresholdLoggingTracerConfig) {
            this.thresholdLoggingTracerConfig = Validators.notNull(thresholdLoggingTracerConfig, "ThresholdLoggingTracerConfig");
            return this.self();
        }

        @Stability.Volatile
        public SELF publishOnScheduler(@Nullable Supplier<Scheduler> publishOnScheduler) {
            this.userScheduler = publishOnScheduler;
            return this.self();
        }

        public ThresholdLoggingTracerConfig.Builder thresholdLoggingTracerConfig() {
            return this.thresholdLoggingTracerConfig;
        }

        @Deprecated
        public SELF compressionConfig(CompressionConfig.Builder compressionConfig) {
            this.compressionConfig = Validators.notNull(compressionConfig, "CompressionConfig");
            return this.self();
        }

        public CompressionConfig.Builder compressionConfig() {
            return this.compressionConfig;
        }

        @Deprecated
        public SELF securityConfig(SecurityConfig.Builder securityConfig) {
            this.securityConfig = Validators.notNull(securityConfig, "SecurityConfig");
            return this.self();
        }

        public SecurityConfig.Builder securityConfig() {
            return this.securityConfig;
        }

        @Deprecated
        public SELF timeoutConfig(TimeoutConfig.Builder timeoutConfig) {
            this.timeoutConfig = Validators.notNull(timeoutConfig, "TimeoutConfig");
            return this.self();
        }

        public TimeoutConfig.Builder timeoutConfig() {
            return this.timeoutConfig;
        }

        @Deprecated
        public SELF loggerConfig(LoggerConfig.Builder loggerConfig) {
            this.loggerConfig = Validators.notNull(loggerConfig, "LoggerConfig");
            return this.self();
        }

        public LoggerConfig.Builder loggerConfig() {
            return this.loggerConfig;
        }

        @Stability.Uncommitted
        public SELF eventBus(EventBus eventBus) {
            this.eventBus = OwnedOrExternal.external(Validators.notNull(eventBus, "EventBus"));
            return this.self();
        }

        @Stability.Uncommitted
        public SELF scheduler(Scheduler scheduler) {
            this.scheduler = OwnedOrExternal.external(Validators.notNull(scheduler, "Scheduler"));
            return this.self();
        }

        @Stability.Uncommitted
        public SELF schedulerThreadCount(int schedulerThreadCount) {
            if (schedulerThreadCount < 1) {
                throw InvalidArgumentException.fromMessage("SchedulerThreadCount cannot be smaller than 1");
            }
            this.schedulerThreadCount = schedulerThreadCount;
            return this.self();
        }

        public SELF retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = Validators.notNull(retryStrategy, "RetryStrategy");
            return this.self();
        }

        @Stability.Volatile
        public SELF requestTracer(RequestTracer requestTracer) {
            Validators.notNull(requestTracer, "RequestTracer");
            this.requestTracer = OwnedOrExternal.external(requestTracer);
            return this.self();
        }

        @Stability.Volatile
        public SELF meter(Meter meter) {
            this.meter = OwnedOrExternal.external(Validators.notNull(meter, "Meter"));
            return this.self();
        }

        @Stability.Internal
        public SELF transactionsConfig(CoreTransactionsConfig transactionsConfig) {
            this.transactionsConfig = transactionsConfig;
            return this.self();
        }

        @Stability.Internal
        public SELF addRequestCallback(RequestCallback requestCallback) {
            this.requestCallbacks.add(Validators.notNull(requestCallback, "RequestCallback"));
            return this.self();
        }

        public CoreEnvironment build() {
            return new CoreEnvironment(this);
        }

        @Stability.Volatile
        public SELF applyProfile(String profileName) {
            Validators.notNullOrEmpty(profileName, "ProfileName");
            for (ConfigurationProfile profile : environmentProfileLoader) {
                if (!profile.name().equals(profileName)) continue;
                this.appliedProfiles.add(profileName);
                return this.load(PropertyLoader.fromMap(profile.properties()));
            }
            throw InvalidArgumentException.fromMessage("Unknown profile: '" + profileName + "', valid profiles are: " + CoreEnvironment.registeredProfileNames());
        }

        public SELF preferredServerGroup(@Nullable String preferredServerGroup) {
            this.preferredServerGroup = preferredServerGroup;
            return this.self();
        }

        @Stability.Internal
        public SELF loadSystemProperties() {
            new SystemPropertyPropertyLoader().load(this);
            return this.self();
        }
    }
}

