/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreReadPreference;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.DocumentUnretrievableException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.core.msg.kv.InsertResponse;
import com.couchbase.client.core.msg.kv.RemoveRequest;
import com.couchbase.client.core.msg.kv.RemoveResponse;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocMutateRequest;
import com.couchbase.client.core.msg.kv.SubdocMutateResponse;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.service.kv.ReplicaHelper;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.support.SpanWrapperUtil;
import com.couchbase.client.core.util.BucketConfigUtil;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class TransactionKVHandler {
    private TransactionKVHandler() {
    }

    public static Mono<InsertResponse> insert(Core core, CollectionIdentifier collectionIdentifier, String id, byte[] transcodedContent, int flags, Duration timeout, Optional<DurabilityLevel> durabilityLevel, Map<String, Object> clientContext, SpanWrapper pspan) {
        return Mono.defer(() -> {
            long start = System.nanoTime();
            SpanWrapper span = SpanWrapperUtil.createOp(null, core.context().coreResources().requestTracer(), collectionIdentifier, id, "insert", pspan);
            InsertRequest request = new InsertRequest(id, transcodedContent, 0L, flags, timeout, core.context(), collectionIdentifier, BestEffortRetryStrategy.INSTANCE, durabilityLevel, span.span());
            request.context().clientContext(clientContext).encodeLatency(System.nanoTime() - start);
            core.send(request);
            return Mono.fromFuture((CompletableFuture)((CompletableFuture)request.response().thenApply(response -> {
                if (response.status().success()) {
                    return response;
                }
                throw response.errorIfNeeded(request);
            })).whenComplete((r, t) -> request.context().logicallyComplete((Throwable)t)));
        });
    }

    public static Mono<RemoveResponse> remove(Core core, CollectionIdentifier collectionIdentifier, String id, Duration timeout, long cas, Optional<DurabilityLevel> durabilityLevel, Map<String, Object> clientContext, SpanWrapper pspan) {
        return Mono.defer(() -> {
            long start = System.nanoTime();
            SpanWrapper span = SpanWrapperUtil.createOp(null, core.context().coreResources().requestTracer(), collectionIdentifier, id, "remove", pspan);
            RemoveRequest request = new RemoveRequest(id, cas, timeout, core.context(), collectionIdentifier, BestEffortRetryStrategy.INSTANCE, durabilityLevel, span.span());
            request.context().clientContext(clientContext).encodeLatency(System.nanoTime() - start);
            core.send(request);
            return Mono.fromFuture((CompletableFuture)((CompletableFuture)request.response().thenApply(response -> {
                if (response.status().success()) {
                    return response;
                }
                throw DefaultErrorUtil.keyValueStatusToException(request, response);
            })).whenComplete((r, t) -> request.context().logicallyComplete((Throwable)t)));
        });
    }

    public static Mono<CoreSubdocGetResult> lookupIn(Core core, CollectionIdentifier collectionIdentifier, String id, Duration timeout, boolean accessDeleted, Map<String, Object> clientContext, @Nullable SpanWrapper pspan, boolean preferredReplicaMode, List<SubdocGetRequest.Command> commands) {
        return Mono.defer(() -> {
            long start = System.nanoTime();
            SpanWrapper span = SpanWrapperUtil.createOp(null, core.context().coreResources().requestTracer(), collectionIdentifier, id, "lookup_in", pspan);
            if (preferredReplicaMode) {
                CompletableFuture<CoreSubdocGetResult> replicas = ReplicaHelper.lookupInAnyReplicaAsync(core, collectionIdentifier, id, SubdocGetRequest.convertCommandsToCore(commands), timeout, BestEffortRetryStrategy.INSTANCE, clientContext, pspan == null ? null : pspan.span(), CoreReadPreference.PREFERRED_SERVER_GROUP, r -> r);
                return Reactor.wrap(replicas, () -> {}).switchIfEmpty(Mono.error((Throwable)new DocumentUnretrievableException(ReducedKeyValueErrorContext.create(id, collectionIdentifier)))).doOnError(span::recordException).doOnTerminate(span::finish);
            }
            byte flags = 0;
            if (accessDeleted) {
                flags = (byte)(flags | 4);
            }
            SubdocGetRequest request = new SubdocGetRequest(timeout, core.context(), collectionIdentifier, BestEffortRetryStrategy.INSTANCE, id, flags, commands, span.span());
            request.context().clientContext(clientContext).encodeLatency(System.nanoTime() - start);
            core.send(request);
            return Mono.fromFuture((CompletableFuture)((CompletableFuture)request.response().thenApply(response -> {
                if (response.status().success() || response.status() == ResponseStatus.SUBDOC_FAILURE) {
                    return response.toCore(CoreKeyspace.from(collectionIdentifier), id);
                }
                throw DefaultErrorUtil.keyValueStatusToException(request, response);
            })).whenComplete((t, e) -> {
                if (e == null || e instanceof DocumentNotFoundException) {
                    request.context().logicallyComplete();
                } else {
                    request.context().logicallyComplete((Throwable)e);
                }
            }));
        });
    }

    public static Mono<SubdocMutateResponse> mutateIn(Core core, CollectionIdentifier collectionIdentifier, String id, Duration timeout, boolean insertDocument, boolean upsertDocument, boolean reviveDocument, boolean accessDeleted, boolean createAsDeleted, long cas, int userFlags, Optional<DurabilityLevel> durabilityLevel, Map<String, Object> clientContext, SpanWrapper span, List<SubdocMutateRequest.Command> commands) {
        return TransactionKVHandler.mutateIn(core, collectionIdentifier, id, timeout, insertDocument, upsertDocument, reviveDocument, accessDeleted, createAsDeleted, cas, userFlags, durabilityLevel, clientContext, span, commands, null);
    }

    public static Mono<SubdocMutateResponse> mutateIn(Core core, CollectionIdentifier collectionIdentifier, String id, Duration timeout, boolean insertDocument, boolean upsertDocument, boolean reviveDocument, boolean accessDeleted, boolean createAsDeleted, long cas, int userFlags, Optional<DurabilityLevel> durabilityLevel, Map<String, Object> clientContext, SpanWrapper pspan, List<SubdocMutateRequest.Command> commands, CoreTransactionLogger logger) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapperUtil.createOp(null, core.context().coreResources().requestTracer(), collectionIdentifier, id, "mutate_in", pspan);
            long start = System.nanoTime();
            boolean requiresBucketConfig = createAsDeleted || reviveDocument;
            CompletableFuture bucketConfigFuture = requiresBucketConfig ? BucketConfigUtil.waitForBucketConfig(core, collectionIdentifier.bucket(), timeout).toFuture() : CompletableFuture.completedFuture(null);
            CompletionStage future = bucketConfigFuture.thenCompose(bucketConfig -> {
                SubdocMutateRequest request = new SubdocMutateRequest(timeout, core.context(), collectionIdentifier, (BucketConfig)bucketConfig, BestEffortRetryStrategy.INSTANCE, id, insertDocument, upsertDocument, reviveDocument, accessDeleted, createAsDeleted, commands, 0L, false, cas, userFlags, durabilityLevel, span.span());
                request.context().clientContext(clientContext).encodeLatency(System.nanoTime() - start);
                core.send(request);
                return ((CompletableFuture)request.response().thenApply(response -> {
                    if (response.status().success()) {
                        return response;
                    }
                    throw response.throwError(request, insertDocument);
                })).whenComplete((r, t) -> request.context().logicallyComplete((Throwable)t));
            });
            return Mono.fromFuture((CompletableFuture)future);
        });
    }
}

