/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.HostAndPort;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class NodeIdentifier {
    private final HostAndPort canonical;
    private final String hostForNetworkConnections;
    private final String uuid;

    public NodeIdentifier(String canonicalHost, int canonicalPort, String hostForNetworkConnections) {
        this(canonicalHost, canonicalPort, hostForNetworkConnections, null);
    }

    public NodeIdentifier(String canonicalHost, int canonicalPort, String hostForNetworkConnections, @Nullable String uuid) {
        this(new HostAndPort(canonicalHost, canonicalPort), hostForNetworkConnections, uuid);
    }

    public NodeIdentifier(HostAndPort canonical, String hostForNetworkConnections, @Nullable String uuid) {
        this.canonical = Objects.requireNonNull(canonical);
        this.hostForNetworkConnections = Objects.requireNonNull(hostForNetworkConnections);
        this.uuid = uuid == null ? this.canonical().format() : uuid;
    }

    public static NodeIdentifier forBootstrap(String bootstrapHost, int bootstrapPort) {
        return new NodeIdentifier(new HostAndPort(bootstrapHost, bootstrapPort), bootstrapHost, null);
    }

    public String uuid() {
        return this.uuid;
    }

    public HostAndPort canonical() {
        return this.canonical;
    }

    @Deprecated
    public com.couchbase.client.core.node.NodeIdentifier toLegacy() {
        return new com.couchbase.client.core.node.NodeIdentifier(this.canonical, this.hostForNetworkConnections);
    }

    public String hostForNetworkConnections() {
        return this.hostForNetworkConnections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeIdentifier that = (NodeIdentifier)o;
        return this.canonical.equals(that.canonical);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    public String toString() {
        return "NodeIdentifier{canonical=" + this.canonical + ", hostForNetworkConnections='" + this.hostForNetworkConnections + '\'' + ", uuid='" + this.uuid + '\'' + '}';
    }
}

