/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.TextNode;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.topology.BucketTopology;
import com.couchbase.client.core.topology.ClusterCapability;
import com.couchbase.client.core.topology.ClusterIdentifier;
import com.couchbase.client.core.topology.ClusterTopology;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.HostAndServicePortsParser;
import com.couchbase.client.core.topology.JacksonHelper;
import com.couchbase.client.core.topology.NetworkSelector;
import com.couchbase.client.core.topology.PortSelector;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
class ClusterTopologyParser {
    private static final Logger log = LoggerFactory.getLogger(ClusterTopologyParser.class);
    private static final TypeReference<Map<String, Set<String>>> SET_MULTIMAP_TYPE = new TypeReference<Map<String, Set<String>>>(){};

    private ClusterTopologyParser() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ClusterTopology parse(ObjectNode clusterConfig, String originHost, PortSelector portSelector, NetworkSelector networkSelector, MemcachedHashingStrategy memcachedHashingStrategy) {
        Objects.requireNonNull(originHost, "originHost must be non-null.");
        if (originHost.endsWith("]")) {
            throw new IllegalArgumentException("Invalid originHost. Expected a hostname, IPv4 address, or IPv6 address (without square brackets), but got: " + originHost);
        }
        ArrayNode nodesExt = (ArrayNode)clusterConfig.get("nodesExt");
        if (nodesExt == null) {
            throw new CouchbaseException("Couchbase Server version is too old for this SDK; missing 'nodesExt' field.");
        }
        List<Map<NetworkResolution, HostAndServicePorts>> nodes = JacksonHelper.transform(nodesExt, node -> HostAndServicePortsParser.parse(ClusterTopologyParser.addHostnameIfMissing(node, originHost), portSelector));
        NetworkResolution resolvedNetwork = networkSelector.selectNetwork(nodes).orElse(NetworkResolution.DEFAULT);
        List<HostAndServicePorts> resolvedNodes = CbCollections.transform(nodes, it -> {
            HostAndServicePorts resolved = it.getOrDefault(resolvedNetwork, HostAndServicePorts.INACCESSIBLE);
            if (resolved.inaccessible()) {
                log.error("Cluster topology has at least one node that is inaccessible on the selected network ({}) : {}", (Object)resolvedNetwork, (Object)RedactableArgument.redactSystem(it));
            }
            return resolved;
        });
        ClusterTopologyParser.sanityCheck(resolvedNodes);
        ArrayNode nodesArray = (ArrayNode)clusterConfig.get("nodes");
        int numberOfKvNodesServicingThisBucket = nodesArray == null ? 0 : nodesArray.size();
        List<HostAndServicePorts> nodesReadyToServiceThisBucket = resolvedNodes.subList(0, numberOfKvNodesServicingThisBucket);
        BucketTopology bucket = BucketTopology.parse(clusterConfig, nodesReadyToServiceThisBucket, memcachedHashingStrategy);
        ClusterIdentifier clusterIdent = ClusterIdentifier.parse(clusterConfig);
        return ClusterTopology.of(TopologyRevision.parse(clusterConfig), clusterIdent, resolvedNodes, ClusterTopologyParser.parseCapabilities(clusterConfig), resolvedNetwork, portSelector, bucket);
    }

    private static void sanityCheck(List<HostAndServicePorts> resolvedNodes) {
        List idsOfAccessibleNodes = resolvedNodes.stream().filter(it -> !it.inaccessible()).map(HostAndServicePorts::id).collect(Collectors.toList());
        HashSet distinct = new HashSet(idsOfAccessibleNodes);
        if (distinct.size() != idsOfAccessibleNodes.size()) {
            throw new CouchbaseException("Cluster topology has nodes with non-unique IDs (host and manager port on default network: " + RedactableArgument.redactSystem(resolvedNodes));
        }
    }

    private static ObjectNode addHostnameIfMissing(JsonNode node, String originHost) {
        ObjectNode obj = (ObjectNode)node;
        if (!node.has("hostname") && node.path("thisNode").asBoolean()) {
            obj.set("hostname", new TextNode(originHost));
        }
        return obj;
    }

    private static Set<ClusterCapability> parseCapabilities(ObjectNode clusterConfig) {
        JsonNode capabilitiesNode = clusterConfig.get("clusterCapabilities");
        if (capabilitiesNode == null) {
            return Collections.emptySet();
        }
        Map<String, Set<String>> map = JacksonHelper.convertValue(capabilitiesNode, SET_MULTIMAP_TYPE);
        EnumSet<ClusterCapability> result = EnumSet.noneOf(ClusterCapability.class);
        ClusterCapability.valueList().forEach(it -> {
            if (map.getOrDefault(it.namespace(), Collections.emptySet()).contains(it.wireName())) {
                result.add((ClusterCapability)((Object)it));
            }
        });
        return result;
    }
}

