/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.logging.RedactableArgument;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ClusterIdentifier {
    private final String clusterUuid;
    private final String clusterName;

    ClusterIdentifier(String clusterUuid, String clusterName) {
        this.clusterUuid = clusterUuid;
        this.clusterName = clusterName;
    }

    @Nullable
    public static ClusterIdentifier parse(ObjectNode config) {
        JsonNode clusterUuid = config.path("clusterUUID");
        JsonNode clusterName = config.path("clusterName");
        if (clusterUuid.isMissingNode() || clusterName.isMissingNode()) {
            return null;
        }
        return new ClusterIdentifier(clusterUuid.asText(), clusterName.asText());
    }

    public String clusterUuid() {
        return this.clusterUuid;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String toString() {
        return "ClusterIdent{clusterUuid='" + this.clusterUuid + '\'' + ", clusterName='" + RedactableArgument.redactMeta(this.clusterName) + '\'' + '}';
    }
}

