/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import java.util.Objects;

@Stability.Internal
public class VersionAndGitHash {
    private final String version;
    private final String gitHash;
    public static final VersionAndGitHash UNKNOWN = new VersionAndGitHash("0.0.0", "");

    private VersionAndGitHash(String version, String gitHash) {
        this.version = Objects.requireNonNull(version);
        this.gitHash = Objects.requireNonNull(gitHash);
    }

    public String version() {
        return this.version;
    }

    public String gitHash() {
        return this.gitHash;
    }

    public String toString() {
        return this.version + " (" + this.gitHash + ")";
    }

    public static VersionAndGitHash from(Class<?> classInSamePackageAsVersionMetadata) {
        String value = classInSamePackageAsVersionMetadata.getPackage().getImplementationVersion();
        if (value == null) {
            return UNKNOWN;
        }
        String[] components = value.split("\\+", 2);
        return components.length == 1 ? new VersionAndGitHash(value, "") : new VersionAndGitHash(components[0], components[1]);
    }
}

