/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Address;
import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.TextParseException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class ReverseMap {
    private static final Name inaddr4 = Name.fromConstantString("in-addr.arpa.");
    private static final Name inaddr6 = Name.fromConstantString("ip6.arpa.");

    private ReverseMap() {
    }

    public static Name fromAddress(byte[] addr) {
        if (addr.length != 4 && addr.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuilder sb = new StringBuilder();
        if (addr.length == 4) {
            for (int i = addr.length - 1; i >= 0; --i) {
                sb.append(addr[i] & 0xFF);
                if (i <= 0) continue;
                sb.append(".");
            }
        } else {
            int[] nibbles = new int[2];
            for (int i = addr.length - 1; i >= 0; --i) {
                nibbles[0] = (addr[i] & 0xFF) >> 4;
                nibbles[1] = addr[i] & 0xF;
                for (int j = nibbles.length - 1; j >= 0; --j) {
                    sb.append(Integer.toHexString(nibbles[j]));
                    if (i <= 0 && j <= 0) continue;
                    sb.append(".");
                }
            }
        }
        try {
            if (addr.length == 4) {
                return Name.fromString(sb.toString(), inaddr4);
            }
            return Name.fromString(sb.toString(), inaddr6);
        }
        catch (TextParseException e) {
            throw new IllegalStateException("name cannot be invalid");
        }
    }

    public static Name fromAddress(int[] addr) {
        byte[] bytes = new byte[addr.length];
        for (int i = 0; i < addr.length; ++i) {
            if (addr[i] < 0 || addr[i] > 255) {
                throw new IllegalArgumentException("array must contain values between 0 and 255");
            }
            bytes[i] = (byte)addr[i];
        }
        return ReverseMap.fromAddress(bytes);
    }

    public static Name fromAddress(InetAddress addr) {
        return ReverseMap.fromAddress(addr.getAddress());
    }

    public static Name fromAddress(String addr, int family) throws UnknownHostException {
        byte[] array = Address.toByteArray(addr, family);
        if (array == null) {
            throw new UnknownHostException("Invalid IP address: " + addr);
        }
        return ReverseMap.fromAddress(array);
    }

    public static Name fromAddress(String addr) throws UnknownHostException {
        byte[] array = Address.toByteArray(addr, 1);
        if (array == null) {
            array = Address.toByteArray(addr, 2);
        }
        if (array == null) {
            throw new UnknownHostException("Invalid IP address: " + addr);
        }
        return ReverseMap.fromAddress(array);
    }

    public static InetAddress fromName(String name) throws UnknownHostException, TextParseException {
        return ReverseMap.fromName(Name.fromString(name));
    }

    public static InetAddress fromName(Name name) throws UnknownHostException {
        byte[] ipBytes;
        if (name.labels() <= 3) {
            throw new UnknownHostException("Not an arpa address: " + name.toString());
        }
        if (name.subdomain(inaddr4)) {
            Name ip = name.relativize(inaddr4);
            if (ip.labels() > 4) {
                throw new UnknownHostException("Invalid IPv4 arpa address: " + name.toString());
            }
            byte[] ipBytes2 = new byte[4];
            try {
                for (int i = 0; i < ip.labels(); ++i) {
                    ipBytes2[ip.labels() - i - 1] = (byte)Integer.parseInt(ip.getLabelString(i));
                }
            }
            catch (NumberFormatException e) {
                throw new UnknownHostException("Invalid IPv4 arpa address: " + name.toString());
            }
            return InetAddress.getByAddress(ipBytes2);
        }
        if (name.subdomain(inaddr6)) {
            Name ip = name.relativize(inaddr6);
            if (ip.labels() > 32) {
                throw new UnknownHostException("Invalid IPv6 arpa address: " + name.toString());
            }
            ipBytes = new byte[16];
            try {
                for (int i = 0; i < ip.labels(); ++i) {
                    int n = (ip.labels() - i - 1) / 2;
                    ipBytes[n] = (byte)(ipBytes[n] | Byte.parseByte(ip.getLabelString(i), 16) << ((ip.labels() - i) % 2 == 0 ? 0 : 4));
                }
            }
            catch (NumberFormatException e) {
                throw new UnknownHostException("Invalid IPv6 arpa address: " + name.toString());
            }
        } else {
            throw new UnknownHostException("Not an arpa address: " + name.toString());
        }
        return InetAddress.getByAddress(ipBytes);
    }
}

