/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.forwards;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.transaction.forwards.ForwardCompatBehaviour;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
class ForwardCompatBehaviourFull {
    public final ForwardCompatBehaviour behaviour;
    public final Optional<Integer> retryAfterMillis;
    public static final ForwardCompatBehaviourFull CONTINUE = new ForwardCompatBehaviourFull(ForwardCompatBehaviour.CONTINUE, Optional.empty());

    ForwardCompatBehaviourFull(JsonNode json) {
        Objects.requireNonNull(json);
        this.behaviour = ForwardCompatBehaviour.create(json.path("b").textValue());
        JsonNode raj = json.get("ra");
        this.retryAfterMillis = raj != null ? Optional.of(raj.asInt()) : Optional.empty();
    }

    ForwardCompatBehaviourFull(ForwardCompatBehaviour behaviour, Optional<Integer> retryAfterMillis) {
        this.behaviour = Objects.requireNonNull(behaviour);
        this.retryAfterMillis = Objects.requireNonNull(retryAfterMillis);
    }
}

