/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.AbstractContext;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.CoreIdGenerator;
import java.util.Map;
import java.util.Objects;

@Stability.Internal
public final class ProtostellarContext
extends AbstractContext {
    private final long id = CoreIdGenerator.nextId();
    private final String hexId = String.format("0x%016x", this.id);
    private final CoreEnvironment env;
    private final Authenticator authenticator;

    public ProtostellarContext(CoreEnvironment env, Authenticator authenticator) {
        this.env = Objects.requireNonNull(env);
        this.authenticator = Objects.requireNonNull(authenticator);
        if (env.securityConfig().tlsEnabled() && !authenticator.supportsTls()) {
            throw InvalidArgumentException.fromMessage("TLS enabled but the Authenticator does not support TLS!");
        }
        if (!env.securityConfig().tlsEnabled() && !authenticator.supportsNonTls()) {
            throw InvalidArgumentException.fromMessage("TLS not enabled but the Authenticator requires TLS!");
        }
    }

    public long id() {
        return this.id;
    }

    public String hexId() {
        return this.hexId;
    }

    public CoreEnvironment environment() {
        return this.env;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        input.put("coreId", this.hexId);
    }
}

