/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.kv.CoreSubdocGetCommand;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class ReplicaSubdocGetRequest
extends SubdocGetRequest {
    private static final byte SUBDOC_DOC_FLAG_REPLICA = 32;
    private final short replica;

    public static ReplicaSubdocGetRequest create(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, byte flags, List<CoreSubdocGetCommand> commands, short replica, RequestSpan span) {
        byte requestFlags = (byte)(flags | 0x20);
        return new ReplicaSubdocGetRequest(timeout, ctx, collectionIdentifier, retryStrategy, key, requestFlags, ReplicaSubdocGetRequest.convertCommands(commands), replica, span);
    }

    ReplicaSubdocGetRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, byte flags, List<SubdocGetRequest.Command> commands, short replica, RequestSpan span) {
        super(timeout, ctx, collectionIdentifier, retryStrategy, key, flags, commands, span);
        this.replica = replica;
        if (span != null) {
            span.attribute("db.operation", "lookup_in_replica");
        }
    }

    public short replica() {
        return this.replica;
    }

    @Override
    public Map<String, Object> serviceContext() {
        Map<String, Object> ctx = super.serviceContext();
        ctx.put("isReplica", true);
        ctx.put("replicaNum", this.replica);
        return ctx;
    }

    @Override
    public String name() {
        return "lookup_in_replica";
    }
}

