/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

public class BucketNotFlushableException
extends CouchbaseException {
    private final String bucketName;

    BucketNotFlushableException(String bucketName) {
        super("Bucket [" + RedactableArgument.redactMeta(bucketName) + "] does not have flush enabled.");
        this.bucketName = Objects.requireNonNull(bucketName);
    }

    public static BucketNotFlushableException forBucket(String bucketName) {
        return new BucketNotFlushableException(bucketName);
    }

    public String bucketName() {
        return this.bucketName;
    }
}

