/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.CouchbaseBucketTopologyParser;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.MemcachedBucketTopologyParser;
import java.util.List;
import java.util.Set;
import reactor.util.annotation.Nullable;

@Stability.Internal
public interface BucketTopology {
    public String uuid();

    public String name();

    public Set<BucketCapability> capabilities();

    default public boolean hasCapability(BucketCapability capability) {
        return this.capabilities().contains((Object)capability);
    }

    @Stability.Internal
    public List<HostAndServicePorts> nodes();

    @Stability.Internal
    @Nullable
    public static BucketTopology parse(ObjectNode json, List<HostAndServicePorts> nodes, MemcachedHashingStrategy memcachedHashingStrategy) {
        switch (json.path("nodeLocator").asText()) {
            case "vbucket": {
                return CouchbaseBucketTopologyParser.parse(json, nodes);
            }
            case "ketama": {
                return MemcachedBucketTopologyParser.parse(json, nodes, memcachedHashingStrategy);
            }
        }
        return null;
    }
}

