/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreGeoCoordinates;
import com.couchbase.client.core.api.search.queries.CoreGeoPoint;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.GeoDistanceQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreGeoDistanceQuery
extends CoreSearchQuery {
    private final CoreGeoPoint location;
    private final String distance;
    @Nullable
    private final String field;

    public CoreGeoDistanceQuery(double locationLon, double locationLat, String distance, @Nullable String field, @Nullable Double boost) {
        this(CoreGeoCoordinates.lon(locationLon).lat(locationLat), distance, field, boost);
    }

    public CoreGeoDistanceQuery(CoreGeoPoint location, String distance, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.location = Objects.requireNonNull(location);
        this.distance = Validators.notNullOrEmpty(distance, "Distance");
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        input.set("location", this.location.toJson());
        input.put("distance", this.distance);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        GeoDistanceQuery.Builder builder = GeoDistanceQuery.newBuilder().setCenter(CoreProtostellarUtil.toLatLng(this.location)).setDistance(this.distance);
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setGeoDistanceQuery(builder).build();
    }
}

