/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.annotation.UsedBy;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.cnc.tracing.NoopRequestSpan;
import com.couchbase.client.core.cnc.tracing.NoopRequestTracer;
import com.couchbase.client.core.cnc.tracing.ThresholdLoggingTracer;
import com.couchbase.client.core.cnc.tracing.ThresholdRequestSpan;
import com.couchbase.client.core.service.ServiceType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

@Stability.Internal
public class CbTracing {
    private static final Map<ServiceType, String> serviceTypeToTracingId;

    private CbTracing() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static boolean isInternalTracer(RequestTracer tracer) {
        return tracer instanceof NoopRequestTracer || tracer instanceof ThresholdLoggingTracer;
    }

    public static boolean isInternalSpan(RequestSpan span) {
        return span instanceof NoopRequestSpan || span instanceof ThresholdRequestSpan;
    }

    @UsedBy(value=UsedBy.Project.SPRING_DATA_COUCHBASE)
    public static RequestSpan newSpan(CoreContext coreContext, String spanName, RequestSpan parent) {
        return coreContext.environment().requestTracer().requestSpan(spanName, parent);
    }

    @Deprecated
    public static RequestSpan newSpan(RequestTracer tracer, String spanName, RequestSpan parent) {
        return tracer.requestSpan(spanName, parent);
    }

    public static void setAttributes(RequestSpan span, Map<String, ?> attributes) {
        if (span == null || attributes == null) {
            return;
        }
        attributes.forEach((k, v) -> {
            if (v instanceof String) {
                span.attribute((String)k, (String)v);
            } else if (v instanceof Integer || v instanceof Long) {
                span.attribute((String)k, ((Number)v).longValue());
            } else if (v instanceof Boolean) {
                span.attribute((String)k, (Boolean)v);
            } else {
                span.attribute((String)k, String.valueOf(v));
            }
        });
    }

    public static String getTracingId(ServiceType serviceType) {
        return serviceTypeToTracingId.getOrDefault((Object)serviceType, serviceType.ident());
    }

    static {
        EnumMap<ServiceType, String> map = new EnumMap<ServiceType, String>(ServiceType.class);
        map.put(ServiceType.ANALYTICS, "analytics");
        map.put(ServiceType.EVENTING, "eventing");
        map.put(ServiceType.BACKUP, "backup");
        map.put(ServiceType.KV, "kv");
        map.put(ServiceType.MANAGER, "management");
        map.put(ServiceType.QUERY, "query");
        map.put(ServiceType.SEARCH, "search");
        map.put(ServiceType.VIEWS, "views");
        serviceTypeToTracingId = Collections.unmodifiableMap(map);
    }
}

