/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.context;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.metrics.CounterName;
import com.couchbase.client.core.cnc.metrics.ResponseMetricIdentifier;
import com.couchbase.client.core.cnc.metrics.WrappedCounter;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.topology.ClusterIdentifier;
import com.couchbase.client.core.topology.ClusterIdentifierUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Stability.Internal
public class CoreTransactionsCounters {
    private final Map<ResponseMetricIdentifier, WrappedCounter> transactionsMetrics = new ConcurrentHashMap<ResponseMetricIdentifier, WrappedCounter>();
    private final Map<ResponseMetricIdentifier, WrappedCounter> attemptMetrics = new ConcurrentHashMap<ResponseMetricIdentifier, WrappedCounter>();
    private final Core core;

    public CoreTransactionsCounters(Core core) {
        this.core = core;
    }

    public WrappedCounter attempts() {
        return this.genericCounter(CounterName.TRANSACTIONS_ATTEMPT_COUNTER, this.attemptMetrics);
    }

    public WrappedCounter transactions() {
        return this.genericCounter(CounterName.TRANSACTIONS_COUNTER, this.transactionsMetrics);
    }

    private WrappedCounter genericCounter(CounterName name, Map<ResponseMetricIdentifier, WrappedCounter> metricsMap) {
        ClusterConfig config = this.core.configurationProvider().config();
        ClusterIdentifier clusterIdent = ClusterIdentifierUtil.fromConfig(config);
        boolean isDefaultLoggingMeter = this.core.coreResources().meter().isDefaultLoggingMeter();
        ResponseMetricIdentifier rmi = new ResponseMetricIdentifier("transactions", "transaction", null, null, null, null, clusterIdent, isDefaultLoggingMeter);
        return metricsMap.computeIfAbsent(rmi, id -> this.core.coreResources().meter().counter(name, (ResponseMetricIdentifier)id));
    }
}

