/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.deps.com.google.common.util.concurrent.FutureCallback;
import com.couchbase.client.core.deps.com.google.common.util.concurrent.Futures;
import com.couchbase.client.core.deps.com.google.common.util.concurrent.ListenableFuture;
import com.couchbase.client.core.endpoint.ProtostellarEndpoint;
import com.couchbase.client.core.io.netty.TracingUtils;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.protostellar.CoreProtostellarErrorHandlingUtil;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarBaseRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.core.util.ProtostellarUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.annotation.Nullable;

public class CoreProtostellarAccessors {
    public static <TSdkResult, TGrpcRequest, TGrpcResponse> TSdkResult blocking(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, Function<ProtostellarEndpoint, TGrpcResponse> executeBlockingGrpcCall, Function<TGrpcResponse, TSdkResult> convertResponse) {
        return CoreProtostellarAccessors.blocking(core, request, executeBlockingGrpcCall, convertResponse, err -> CoreProtostellarErrorHandlingUtil.convertException(core, request, err));
    }

    public static <TSdkResult, TGrpcRequest, TGrpcResponse> TSdkResult blocking(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, Function<ProtostellarEndpoint, TGrpcResponse> executeBlockingGrpcCall, Function<TGrpcResponse, TSdkResult> convertResponse, Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        while (true) {
            CoreProtostellarUtil.handleShutdownBlocking(core, request);
            ProtostellarEndpoint endpoint = core.endpoint();
            long start = System.nanoTime();
            RequestSpan dispatchSpan = CoreProtostellarAccessors.createDispatchSpan(core, request, endpoint);
            AutoCloseable scope = ProtostellarUtil.activateSpan(Optional.empty(), dispatchSpan, core.context().coreResources().requestTracer());
            try {
                TGrpcResponse response = executeBlockingGrpcCall.apply(endpoint);
                request.dispatchDuration(System.nanoTime() - start);
                CoreProtostellarAccessors.handleDispatchSpan(null, dispatchSpan, scope);
                TSdkResult result = convertResponse.apply(response);
                request.raisedResponseToUser(null);
                return result;
            }
            catch (Throwable t) {
                request.dispatchDuration(System.nanoTime() - start);
                ProtostellarRequestBehaviour behaviour = convertException.apply(t);
                CoreProtostellarAccessors.handleDispatchSpan(behaviour, dispatchSpan, scope);
                if (behaviour.retryDuration() != null) {
                    try {
                        Thread.sleep(behaviour.retryDuration().toMillis());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    continue;
                }
                request.raisedResponseToUser(behaviour.exception());
                throw behaviour.exception();
            }
            break;
        }
    }

    public static <TSdkResult, TGrpcRequest, TGrpcResponse> CoreAsyncResponse<TSdkResult> async(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, Function<ProtostellarEndpoint, ListenableFuture<TGrpcResponse>> executeFutureGrpcCall, Function<TGrpcResponse, TSdkResult> convertResponse) {
        return CoreProtostellarAccessors.async(core, request, executeFutureGrpcCall, convertResponse, err -> CoreProtostellarErrorHandlingUtil.convertException(core, request, err));
    }

    public static <TSdkResult, TGrpcRequest, TGrpcResponse> CoreAsyncResponse<TSdkResult> async(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, Function<ProtostellarEndpoint, ListenableFuture<TGrpcResponse>> executeFutureGrpcCall, Function<TGrpcResponse, TSdkResult> convertResponse, Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        CompletableFuture ret = new CompletableFuture();
        CoreAsyncResponse response = new CoreAsyncResponse(ret, () -> {});
        CoreProtostellarAccessors.asyncInternal(ret, core, request, executeFutureGrpcCall, convertResponse, convertException);
        return response;
    }

    public static <TSdkResult, TGrpcRequest, TGrpcResponse> void asyncInternal(final CompletableFuture<TSdkResult> ret, final CoreProtostellar core, final ProtostellarRequest<TGrpcRequest> request, final Function<ProtostellarEndpoint, ListenableFuture<TGrpcResponse>> executeFutureGrpcCall, final Function<TGrpcResponse, TSdkResult> convertResponse, final Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        if (CoreProtostellarUtil.handleShutdownAsync(core, ret, request)) {
            return;
        }
        ProtostellarEndpoint endpoint = core.endpoint();
        final RequestSpan dispatchSpan = CoreProtostellarAccessors.createDispatchSpan(core, request, endpoint);
        final long start = System.nanoTime();
        final AutoCloseable scope = ProtostellarUtil.activateSpan(Optional.empty(), dispatchSpan, core.context().coreResources().requestTracer());
        ListenableFuture<TGrpcResponse> response = executeFutureGrpcCall.apply(endpoint);
        Futures.addCallback(response, new FutureCallback<TGrpcResponse>(){

            @Override
            public void onSuccess(TGrpcResponse response) {
                request.dispatchDuration(System.nanoTime() - start);
                CoreProtostellarAccessors.handleDispatchSpan(null, dispatchSpan, scope);
                Object result = convertResponse.apply(response);
                if (request.completed()) {
                    core.context().environment().orphanReporter().report(new ProtostellarBaseRequest(core, request));
                } else {
                    request.raisedResponseToUser(null);
                    ret.complete(result);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                request.dispatchDuration(System.nanoTime() - start);
                ProtostellarRequestBehaviour behaviour = (ProtostellarRequestBehaviour)convertException.apply(t);
                CoreProtostellarAccessors.handleDispatchSpan(behaviour, dispatchSpan, scope);
                if (behaviour.retryDuration() != null) {
                    boolean unableToSchedule;
                    boolean bl = unableToSchedule = core.context().environment().timer().schedule(() -> CoreProtostellarAccessors.asyncInternal(ret, core, request, executeFutureGrpcCall, convertResponse, convertException), behaviour.retryDuration(), true) == null;
                    if (unableToSchedule) {
                        RuntimeException err = request.cancel(CancellationReason.TOO_MANY_REQUESTS_IN_RETRY).exception();
                        if (!request.completed()) {
                            request.raisedResponseToUser(err);
                            ret.completeExceptionally(err);
                        }
                    }
                } else if (!request.completed()) {
                    request.raisedResponseToUser(behaviour.exception());
                    ret.completeExceptionally(behaviour.exception());
                }
            }
        }, core.context().environment().executor());
    }

    public static <TSdkResult, TGrpcRequest, TGrpcResponse> Mono<TSdkResult> reactive(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, Function<ProtostellarEndpoint, ListenableFuture<TGrpcResponse>> executeFutureGrpcCall, Function<TGrpcResponse, TSdkResult> convertResponse) {
        return Mono.defer(() -> {
            Sinks.One ret = Sinks.one();
            CoreProtostellarAccessors.reactiveInternal(ret, core, request, executeFutureGrpcCall, convertResponse, err -> CoreProtostellarErrorHandlingUtil.convertException(core, request, err));
            return ret.asMono();
        });
    }

    public static <TSdkResult, TGrpcRequest, TGrpcResponse> Mono<TSdkResult> reactive(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, Function<ProtostellarEndpoint, ListenableFuture<TGrpcResponse>> executeFutureGrpcCall, Function<TGrpcResponse, TSdkResult> convertResponse, Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        return Mono.defer(() -> {
            Sinks.One ret = Sinks.one();
            CoreProtostellarAccessors.reactiveInternal(ret, core, request, executeFutureGrpcCall, convertResponse, convertException);
            return ret.asMono();
        });
    }

    public static <TSdkResult, TGrpcRequest, TGrpcResponse> void reactiveInternal(final Sinks.One<TSdkResult> ret, final CoreProtostellar core, final ProtostellarRequest<TGrpcRequest> request, final Function<ProtostellarEndpoint, ListenableFuture<TGrpcResponse>> executeFutureGrpcCall, final Function<TGrpcResponse, TSdkResult> convertResponse, final Function<Throwable, ProtostellarRequestBehaviour> convertException) {
        if (CoreProtostellarUtil.handleShutdownReactive(ret, core, request)) {
            return;
        }
        ProtostellarEndpoint endpoint = core.endpoint();
        final RequestSpan dispatchSpan = CoreProtostellarAccessors.createDispatchSpan(core, request, endpoint);
        final long start = System.nanoTime();
        final AutoCloseable scope = ProtostellarUtil.activateSpan(Optional.empty(), dispatchSpan, core.context().coreResources().requestTracer());
        ListenableFuture<TGrpcResponse> response = executeFutureGrpcCall.apply(endpoint);
        Futures.addCallback(response, new FutureCallback<TGrpcResponse>(){

            @Override
            public void onSuccess(TGrpcResponse response) {
                if (request.completed()) {
                    core.context().environment().orphanReporter().report(new ProtostellarBaseRequest(core, request));
                } else {
                    request.dispatchDuration(System.nanoTime() - start);
                    CoreProtostellarAccessors.handleDispatchSpan(null, dispatchSpan, scope);
                    Object result = convertResponse.apply(response);
                    request.raisedResponseToUser(null);
                    ret.tryEmitValue(result).orThrow();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                request.dispatchDuration(System.nanoTime() - start);
                ProtostellarRequestBehaviour behaviour = (ProtostellarRequestBehaviour)convertException.apply(t);
                CoreProtostellarAccessors.handleDispatchSpan(behaviour, dispatchSpan, scope);
                if (behaviour.retryDuration() != null) {
                    boolean unableToSchedule;
                    boolean bl = unableToSchedule = core.context().environment().timer().schedule(() -> CoreProtostellarAccessors.reactiveInternal(ret, core, request, executeFutureGrpcCall, convertResponse, convertException), behaviour.retryDuration(), true) == null;
                    if (unableToSchedule) {
                        RuntimeException err = request.cancel(CancellationReason.TOO_MANY_REQUESTS_IN_RETRY).exception();
                        if (!request.completed()) {
                            request.raisedResponseToUser(err);
                            ret.tryEmitError((Throwable)err).orThrow();
                        }
                    }
                } else if (!request.completed()) {
                    request.raisedResponseToUser(behaviour.exception());
                    ret.tryEmitError((Throwable)behaviour.exception()).orThrow();
                }
            }
        }, core.context().environment().executor());
    }

    private static void handleDispatchSpan(@Nullable ProtostellarRequestBehaviour behaviour, @Nullable RequestSpan dispatchSpan, @Nullable AutoCloseable scope) {
        if (dispatchSpan != null) {
            if (behaviour != null) {
                dispatchSpan.status(RequestSpan.StatusCode.ERROR);
                if (behaviour.exception() != null) {
                    dispatchSpan.recordException(behaviour.exception());
                }
            }
            dispatchSpan.end();
        }
        if (scope != null) {
            try {
                scope.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Nullable
    private static <TGrpcRequest> RequestSpan createDispatchSpan(CoreProtostellar core, ProtostellarRequest<TGrpcRequest> request, ProtostellarEndpoint endpoint) {
        RequestSpan dispatchSpan;
        RequestTracer tracer = core.context().coreResources().requestTracer();
        if (!CbTracing.isInternalTracer(tracer)) {
            dispatchSpan = tracer.requestSpan("dispatch_to_server", request.span());
            HostAndPort remote = endpoint.hostAndPort();
            TracingDecorator tip = core.context().coreResources().tracingDecorator();
            TracingUtils.setCommonDispatchSpanAttributes(tip, dispatchSpan, null, null, 0, remote.host(), remote.port(), remote.host(), remote.port(), null);
        } else {
            dispatchSpan = null;
        }
        return dispatchSpan;
    }
}

