/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.chunk;

import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.cnc.events.io.ChannelClosedProactivelyEvent;
import com.couchbase.client.core.cnc.events.io.UnsupportedResponseTypeReceivedEvent;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.deps.io.netty.channel.ChannelDuplexHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.LastHttpContent;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.HandlerUtils;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.io.netty.TracingUtils;
import com.couchbase.client.core.io.netty.chunk.ChunkResponseParser;
import com.couchbase.client.core.io.netty.kv.ChannelAttributes;
import com.couchbase.client.core.msg.HttpRequest;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.chunk.ChunkHeader;
import com.couchbase.client.core.msg.chunk.ChunkRow;
import com.couchbase.client.core.msg.chunk.ChunkTrailer;
import com.couchbase.client.core.msg.chunk.ChunkedResponse;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import java.util.Optional;

@ChannelHandler.Sharable
public abstract class ChunkedMessageHandler<H extends ChunkHeader, ROW extends ChunkRow, T extends ChunkTrailer, R extends ChunkedResponse<H, ROW, T>, REQ extends HttpRequest<H, ROW, T, R>>
extends ChannelDuplexHandler {
    private final EndpointContext endpointContext;
    private final ChunkResponseParser<H, ROW, T> chunkResponseParser;
    private final BaseEndpoint endpoint;
    private final boolean pipelined;
    private IoContext ioContext;
    private String remoteHost;
    private REQ currentRequest;
    private RequestSpan currentDispatchSpan;
    private R currentResponse;
    private HttpResponse currentResponseStatus;
    private ResponseStatus convertedResponseStatus;
    private long dispatchTimingStart;

    protected ChunkedMessageHandler(BaseEndpoint endpoint, EndpointContext endpointContext, ChunkResponseParser<H, ROW, T> chunkResponseParser) {
        this.endpoint = endpoint;
        this.endpointContext = endpointContext;
        this.chunkResponseParser = chunkResponseParser;
        this.pipelined = endpoint.pipelined();
        if (this.pipelined) {
            throw new CouchbaseException("The ChunkedMessageHandler does not support pipelining, this is a bug!");
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        block6: {
            if (!this.pipelined && this.currentRequest != null) {
                RetryOrchestrator.maybeRetry(this.endpointContext, (HttpRequest)msg, RetryReason.NOT_PIPELINED_REQUEST_IN_FLIGHT);
                if (this.endpoint != null) {
                    this.endpoint.decrementOutstandingRequests();
                }
                return;
            }
            try {
                this.currentRequest = (HttpRequest)msg;
                FullHttpRequest encoded = (FullHttpRequest)this.currentRequest.encode();
                encoded.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.remoteHost);
                encoded.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.endpointContext.environment().userAgent().formattedLong());
                this.chunkResponseParser.updateRequestContext(this.currentRequest.context());
                this.dispatchTimingStart = System.nanoTime();
                if (this.currentRequest.requestSpan() != null) {
                    RequestTracer tracer = this.endpointContext.coreResources().requestTracer();
                    this.currentDispatchSpan = tracer.requestSpan("dispatch_to_server", this.currentRequest.requestSpan());
                    if (!CbTracing.isInternalTracer(tracer)) {
                        TracingDecorator tip = this.endpointContext.coreResources().tracingDecorator();
                        TracingUtils.setCommonDispatchSpanAttributes(tip, this.currentDispatchSpan, ctx.channel().attr(ChannelAttributes.CHANNEL_ID_KEY).get(), this.ioContext.localHostname(), this.ioContext.localPort(), this.currentRequest.context().lastDispatchedToNode().canonical().host(), this.endpoint.remotePort(), this.endpoint.remoteHostname(), this.endpoint.remotePort(), this.currentRequest.operationId());
                    }
                }
                ctx.write(encoded, promise);
            }
            catch (Throwable t) {
                this.currentRequest.response().completeExceptionally(t);
                if (this.endpoint == null) break block6;
                this.endpoint.decrementOutstandingRequests();
            }
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.remoteHost = this.endpoint.remoteHostname() + ":" + this.endpoint.remotePort();
        this.ioContext = new IoContext(this.endpointContext, ctx.channel().localAddress(), ctx.channel().remoteAddress(), this.endpointContext.bucket());
        ctx.fireChannelActive();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (msg instanceof HttpResponse) {
                this.handleHttpResponse(ctx, (HttpResponse)msg);
            } else if (msg instanceof HttpContent) {
                ((HttpContent)msg).retain();
                this.handleHttpContent((HttpContent)msg);
                if (msg instanceof LastHttpContent) {
                    this.chunkResponseParser.endOfInput();
                    if (!this.isSuccess()) {
                        this.maybeCompleteResponseWithFailure();
                    }
                    this.cleanupState();
                    if (this.endpoint != null) {
                        this.endpoint.markRequestCompletion();
                    }
                }
            } else {
                this.ioContext.environment().eventBus().publish(new UnsupportedResponseTypeReceivedEvent(this.ioContext, msg));
                HandlerUtils.closeChannelWithReason(this.ioContext, ctx, ChannelClosedProactivelyEvent.Reason.INVALID_RESPONSE_FORMAT_DETECTED);
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.cleanupState();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.currentRequest != null) {
            RetryOrchestrator.maybeRetry(this.ioContext, this.currentRequest, RetryReason.CHANNEL_CLOSED_WHILE_IN_FLIGHT);
        }
        ctx.fireChannelInactive();
    }

    private void handleHttpResponse(ChannelHandlerContext ctx, HttpResponse msg) {
        this.currentRequest.context().dispatchLatency(System.nanoTime() - this.dispatchTimingStart);
        if (this.currentDispatchSpan != null) {
            this.currentDispatchSpan.end();
        }
        this.currentResponseStatus = msg;
        this.chunkResponseParser.updateResponseHeader(msg);
        this.convertedResponseStatus = HttpProtocol.decodeStatus(msg.status());
        this.chunkResponseParser.initialize(ctx.channel().config());
    }

    private void handleHttpContent(HttpContent msg) {
        this.chunkResponseParser.feed(msg.content());
        boolean isLastChunk = msg instanceof LastHttpContent;
        if (this.currentResponse == null && this.isSuccess() && this.chunkResponseParser.header(isLastChunk).isPresent()) {
            this.completeInitialResponse((ChunkHeader)this.chunkResponseParser.header(isLastChunk).get());
        }
    }

    private boolean isSuccess() {
        return this.convertedResponseStatus.success() && !this.chunkResponseParser.decodingFailure().isPresent();
    }

    private void completeInitialResponse(H header) {
        this.currentResponse = this.currentRequest.decode(this.convertedResponseStatus, header, this.chunkResponseParser.rows(), this.chunkResponseParser.trailer());
        if (!this.currentRequest.completed()) {
            this.currentRequest.succeed(this.currentResponse);
        } else {
            this.ioContext.environment().orphanReporter().report((Request<?>)this.currentRequest);
        }
    }

    private void maybeCompleteResponseWithFailure() {
        if (!this.currentRequest.completed()) {
            CouchbaseException cause = this.chunkResponseParser.decodingFailure().orElseGet(() -> this.chunkResponseParser.error().orElseGet(() -> new CouchbaseException("Request failed, but no more information available")));
            Optional<RetryReason> qualifies = this.qualifiesForRetry(cause);
            if (qualifies.isPresent()) {
                RetryOrchestrator.maybeRetry(this.ioContext, this.currentRequest, qualifies.get());
            } else {
                this.currentRequest.fail(cause);
            }
        } else {
            this.ioContext.environment().orphanReporter().report((Request<?>)this.currentRequest);
        }
    }

    protected Optional<RetryReason> qualifiesForRetry(CouchbaseException exception) {
        return Optional.empty();
    }

    private void cleanupState() {
        this.chunkResponseParser.cleanup();
        this.currentResponse = null;
        this.currentRequest = null;
        this.currentDispatchSpan = null;
        this.currentResponseStatus = null;
        this.dispatchTimingStart = 0L;
    }
}

