/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Stability.Internal
public class ClassicExpiryHelper {
    private static final int MAXIMUM_RELATIVE_EXPIRY_SECONDS = (int)TimeUnit.DAYS.toSeconds(30L);

    private ClassicExpiryHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static long encode(CoreExpiry expiry) {
        return ClassicExpiryHelper.encode(expiry, System::currentTimeMillis);
    }

    public static long encode(CoreExpiry expiry, Supplier<Long> millisClock) {
        if (expiry.isNone()) {
            return 0L;
        }
        Instant instant = expiry.absolute();
        if (instant != null) {
            return instant.getEpochSecond();
        }
        return ClassicExpiryHelper.encode(expiry.relative(), millisClock);
    }

    private static long encode(Duration duration, Supplier<Long> millisClock) {
        long seconds = duration.getSeconds();
        if (seconds <= (long)MAXIMUM_RELATIVE_EXPIRY_SECONDS) {
            return seconds;
        }
        long epochSecond = millisClock.get() / 1000L + seconds;
        if (epochSecond > CoreExpiry.LATEST_VALID_EXPIRY_INSTANT.getEpochSecond()) {
            throw InvalidArgumentException.fromMessage("Requested expiry duration " + duration + " is too long; the final expiry time must be <= " + CoreExpiry.LATEST_VALID_EXPIRY_INSTANT);
        }
        return epochSecond;
    }
}

