/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.manager;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.core.util.CbStrings;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class CoreQueryIndex {
    private final String name;
    private final boolean primary;
    private final String state;
    private final String keyspace;
    private final String namespace;
    private final ArrayNode indexKey;
    private final String type;
    private final Optional<String> condition;
    private final Optional<String> partition;
    private final ObjectNode raw;
    private final Optional<String> scopeName;
    private final Optional<String> bucketName;

    public CoreQueryIndex(QueryChunkRow row) {
        try {
            this.raw = (ObjectNode)Mapper.reader().readTree(Objects.requireNonNull(row.data()));
            this.name = this.raw.path("name").textValue();
            this.state = this.raw.path("state").textValue();
            this.keyspace = this.raw.path("keyspace_id").textValue();
            this.namespace = this.raw.path("namespace_id").textValue();
            this.indexKey = (ArrayNode)this.raw.path("index_key");
            this.condition = Optional.ofNullable(CbStrings.emptyToNull(this.raw.path("condition").textValue()));
            this.primary = Boolean.TRUE.equals(this.raw.path("is_primary").asBoolean());
            this.type = CbObjects.defaultIfNull(this.raw.path("using").textValue(), "gsi");
            this.partition = Optional.ofNullable(CbStrings.emptyToNull(this.raw.path("partition").textValue()));
            this.scopeName = Optional.ofNullable(CbStrings.emptyToNull(this.raw.path("scope_id").textValue()));
            this.bucketName = Optional.ofNullable(CbStrings.emptyToNull(this.raw.path("bucket_id").textValue()));
        }
        catch (IOException e) {
            throw new DecodingFailureException(e);
        }
    }

    public boolean primary() {
        return this.primary;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String state() {
        return this.state;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String namespace() {
        return this.namespace;
    }

    public ArrayNode indexKey() {
        return this.indexKey;
    }

    public Optional<String> condition() {
        return this.condition;
    }

    public Optional<String> partition() {
        return this.partition;
    }

    public Optional<String> scopeName() {
        return this.scopeName;
    }

    public String bucketName() {
        return this.bucketName.orElse(this.keyspace);
    }

    public Optional<String> collectionName() {
        return this.bucketName.isPresent() && this.scopeName.isPresent() ? Optional.of(this.keyspace) : Optional.empty();
    }

    public ObjectNode raw() {
        return this.raw;
    }
}

