/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.core.TooManyInstancesDetectedEvent;
import com.couchbase.client.core.error.TooManyInstancesException;

@Stability.Internal
public class CoreLimiter {
    private static int maxAllowedInstances = 1;
    private static int numInstances = 0;
    private static boolean failIfInstanceLimitReached = false;

    private CoreLimiter() {
    }

    public static synchronized void setMaxAllowedInstances(int maxAllowedInstances) {
        if (maxAllowedInstances < 1) {
            throw new IllegalArgumentException("maxAllowedInstances must be > 0, but was " + maxAllowedInstances);
        }
        CoreLimiter.maxAllowedInstances = maxAllowedInstances;
    }

    public static synchronized int getMaxAllowedInstances() {
        return maxAllowedInstances;
    }

    public static synchronized void setFailIfInstanceLimitReached(boolean failIfInstanceLimitReached) {
        CoreLimiter.failIfInstanceLimitReached = failIfInstanceLimitReached;
    }

    public static boolean getFailIfInstanceLimitReached() {
        return failIfInstanceLimitReached;
    }

    public static synchronized int numInstances() {
        return numInstances;
    }

    static synchronized void incrementAndVerifyNumInstances(EventBus eventBus) {
        if (numInstances >= maxAllowedInstances) {
            int newNumInstances = numInstances + 1;
            String msg = "The number of simultaneously connected Cluster instances (" + newNumInstances + ") exceeds the configurable warning threshold of " + maxAllowedInstances + ". This is a diagnostic message to help detect potential resource leaks and inefficient usage patterns. If you actually intended to create this many instances, please ignore this warning, or increase the warning threshold by calling Cluster.maxAllowedInstances(int) on startup. However, if you did not intend to have " + newNumInstances + " Cluster instances connected at the same time, this warning may indicate a resource leak. In that case, please make sure to call cluster.disconnect() after a Cluster and its associated Buckets, Scopes, Collections, etc. are no longer required by your application. Also note that Cluster, Bucket, Scope, and Collection instances are thread-safe and reusable until the Cluster is disconnected; for best performance, reuse the same instances throughout your application's lifetime.";
            if (failIfInstanceLimitReached) {
                msg = msg + " This warning was upgraded to an exception because of an earlier call to Cluster.failIfInstanceLimitReached(true).";
                throw new TooManyInstancesException(msg);
            }
            eventBus.publish(new TooManyInstancesDetectedEvent(msg));
        }
        ++numInstances;
    }

    static synchronized void decrement() {
        --numInstances;
    }
}

