/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.GetResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;

public class GetRequest
extends BaseKeyValueRequest<GetResponse> {
    public GetRequest(String key, Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        if (span != null && !CbTracing.isInternalSpan(span)) {
            TracingDecorator tip = ctx.coreResources().tracingDecorator();
            tip.provideLowCardinalityAttr(TracingAttribute.OPERATION, span, "get");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        try {
            key = this.encodedKeyWithCollection(alloc, ctx);
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.GET, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), key, MemcacheProtocol.noBody());
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        return byteBuf;
    }

    @Override
    public GetResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        long cas = MemcacheProtocol.cas(response);
        if (status.success()) {
            byte[] content = MemcacheProtocol.bodyAsBytes(response);
            int flags = MemcacheProtocol.extrasAsInt(response, 0, 0);
            return new GetResponse(status, content, cas, flags);
        }
        return new GetResponse(status, null, cas, 0);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public String name() {
        return "get";
    }
}

