/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.json.stream;

class GrowthStrategy {
    static final int THRESHOLD = 0x400000;

    private GrowthStrategy() {
    }

    static int adjustSize(int minRequired) {
        if (minRequired < 0) {
            throw new IndexOutOfBoundsException("Cannot grow beyond 2147483647");
        }
        int newSize = minRequired < 0x400000 ? GrowthStrategy.ceilPowerOfTwo(minRequired) : GrowthStrategy.divideRoundUp(minRequired, 0x400000) * 0x400000;
        return newSize < 0 ? Integer.MAX_VALUE : newSize;
    }

    private static int ceilPowerOfTwo(int x) {
        int result = Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(x - 1) - 1;
        if (result < 0) {
            throw new ArithmeticException("Next positive power of 2 for value " + x + " is greater than Integer.MAX_VALUE");
        }
        return result;
    }

    private static int divideRoundUp(int numerator, int denominator) {
        return (numerator + denominator - 1) / denominator;
    }
}

