/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import com.couchbase.client.core.annotation.Stability;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;

@Stability.Internal
class CallbackHelper {
    private CallbackHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    static String getUsername(CallbackHandler callbackHandler) throws SaslException {
        NameCallback nameCallback = new NameCallback("Username");
        try {
            callbackHandler.handle(new Callback[]{nameCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new SaslException("Missing callback fetch username", e);
        }
        String name = nameCallback.getName();
        if (name == null || name.isEmpty()) {
            throw new SaslException("Missing username");
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPassword(CallbackHandler callbackHandler) throws SaslException {
        PasswordCallback passwordCallback = new PasswordCallback("Password", false);
        try {
            try {
                callbackHandler.handle(new Callback[]{passwordCallback});
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw new SaslException("Missing callback fetch password", e);
            }
            char[] pw = passwordCallback.getPassword();
            if (pw == null) {
                throw new SaslException("Password can't be null");
            }
            String result = new String(pw);
            Arrays.fill(pw, ' ');
            String string = result;
            return string;
        }
        finally {
            passwordCallback.clearPassword();
        }
    }
}

