/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class TracingUtils {
    private TracingUtils() {
    }

    public static void setCommonDispatchSpanAttributes(TracingDecorator tip, RequestSpan span, @Nullable String localId, @Nullable String localHost, int localPort, @Nullable String remoteCanonicalHost, int remoteCanonicalPort, @Nullable String remoteActualHost, int remoteActualPort, @Nullable String operationId) {
        tip.provideCommonDispatchSpanAttributes(span, localId, localHost, localPort, remoteCanonicalHost, remoteCanonicalPort, remoteActualHost, remoteActualPort, operationId);
    }

    public static void setCommonKVSpanAttributes(RequestSpan span, KeyValueRequest<Response> request) {
        SyncDurabilityRequest syncDurabilityRequest;
        CollectionIdentifier collectionIdentifier = request.collectionIdentifier();
        TracingDecorator tip = request.context().coreResources().tracingDecorator();
        if (collectionIdentifier != null) {
            tip.provideLowCardinalityAttr(TracingAttribute.BUCKET_NAME, span, collectionIdentifier.bucket());
            tip.provideAttr(TracingAttribute.SCOPE_NAME, span, collectionIdentifier.scope().orElse("_default"));
            tip.provideAttr(TracingAttribute.COLLECTION_NAME, span, collectionIdentifier.collection().orElse("_default"));
        }
        tip.provideAttr(TracingAttribute.DOCUMENT_ID, span, new String(request.key()));
        if (request instanceof SyncDurabilityRequest && (syncDurabilityRequest = (SyncDurabilityRequest)((Object)request)).durabilityLevel() != null) {
            tip.provideLowCardinalityAttr(TracingAttribute.DURABILITY, span, syncDurabilityRequest.durabilityLevel().map(Enum::name).orElse(DurabilityLevel.NONE.name()));
        }
    }

    public static void setServerDurationAttribute(TracingDecorator tip, RequestSpan span, long serverDuration) {
        if (serverDuration > 0L) {
            tip.provideAttr(TracingAttribute.SERVER_DURATION, span, serverDuration);
        }
    }
}

