/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.ResponseStatus;
import java.util.Collections;
import java.util.Map;

@Stability.Uncommitted
public class EventingErrorContext
extends ErrorContext {
    private final RequestContext requestContext;
    private final int httpStatus;
    private final Map<String, Object> responseProperties;

    public EventingErrorContext(ResponseStatus responseStatus, RequestContext requestContext, int httpStatus, Map<String, Object> responseProperties) {
        super(responseStatus);
        this.requestContext = requestContext;
        this.httpStatus = httpStatus;
        this.responseProperties = responseProperties;
    }

    public RequestContext requestContext() {
        return this.requestContext;
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public Map<String, Object> responseProperties() {
        return this.responseProperties == null ? Collections.emptyMap() : this.responseProperties;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.requestContext != null) {
            this.requestContext.injectExportableParams(input);
        }
        input.put("httpStatus", this.httpStatus);
        if (this.responseProperties != null) {
            input.put("eventing", this.responseProperties);
        }
    }
}

