/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.AuthenticatorWrapper;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Stability.Internal
public class DelegatingAuthenticator
extends AuthenticatorWrapper {
    private volatile Authenticator delegate;
    private final boolean tls;

    public static DelegatingAuthenticator create(boolean tls, Authenticator delegate) {
        return new DelegatingAuthenticator(tls, delegate);
    }

    public void setDelegate(Authenticator delegate) {
        if (delegate.requiresTls() && !this.tls) {
            throw new IllegalArgumentException("The specified authenticator requires TLS, but TLS is not enabled.");
        }
        this.delegate = Objects.requireNonNull(delegate);
    }

    DelegatingAuthenticator(boolean tls, Authenticator delegate) {
        this.tls = tls;
        this.setDelegate(delegate);
    }

    @Override
    public Authenticator wrapped() {
        return this.delegate;
    }

    public String toString() {
        return "DelegatingAuthenticator{delegate=" + this.delegate + '}';
    }
}

