/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.netty.channel.epoll;

import com.couchbase.client.core.deps.io.netty.channel.epoll.Native;
import com.couchbase.client.core.deps.io.netty.channel.unix.Buffer;
import com.couchbase.client.core.deps.io.netty.util.internal.CleanableDirectBuffer;
import com.couchbase.client.core.deps.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public final class EpollEventArray {
    private static final int EPOLL_EVENT_SIZE = Native.sizeofEpollEvent();
    private static final int EPOLL_DATA_OFFSET = Native.offsetofEpollData();
    private CleanableDirectBuffer cleanable;
    private ByteBuffer memory;
    private long memoryAddress;
    private int length;

    EpollEventArray(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must be >= 1 but was " + length);
        }
        this.length = length;
        this.cleanable = Buffer.allocateDirectBufferWithNativeOrder(EpollEventArray.calculateBufferCapacity(length));
        this.memory = this.cleanable.buffer();
        this.memoryAddress = Buffer.memoryAddress(this.memory);
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    int length() {
        return this.length;
    }

    void increase() {
        this.length <<= 1;
        CleanableDirectBuffer buffer = Buffer.allocateDirectBufferWithNativeOrder(EpollEventArray.calculateBufferCapacity(this.length));
        this.cleanable.clean();
        this.cleanable = buffer;
        this.memory = buffer.buffer();
        this.memoryAddress = Buffer.memoryAddress(buffer.buffer());
    }

    void free() {
        this.cleanable.clean();
        this.memoryAddress = 0L;
    }

    int events(int index) {
        return this.getInt(index, 0);
    }

    int fd(int index) {
        return this.getInt(index, EPOLL_DATA_OFFSET);
    }

    private int getInt(int index, int offset) {
        if (PlatformDependent.hasUnsafe()) {
            long n = (long)index * (long)EPOLL_EVENT_SIZE;
            return PlatformDependent.getInt(this.memoryAddress + n + (long)offset);
        }
        return this.memory.getInt(index * EPOLL_EVENT_SIZE + offset);
    }

    private static int calculateBufferCapacity(int capacity) {
        return capacity * EPOLL_EVENT_SIZE;
    }
}

