/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.collector;

import com.couchbase.client.core.topology.NodeIdentifier;
import java.util.Map;
import java.util.Objects;
import reactor.util.annotation.Nullable;

class NodeAndBucket {
    public final NodeIdentifier nodeId;
    @Nullable
    public final String bucket;

    NodeAndBucket(NodeIdentifier nodeId, @Nullable String bucket) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.bucket = bucket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeAndBucket that = (NodeAndBucket)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.bucket, that.bucket);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.bucket);
    }

    public String toString() {
        return "NodeAndBucket{nodeId='" + this.nodeId + '\'' + ", bucket='" + this.bucket + '\'' + '}';
    }

    void writeTo(Map<String, String> map) {
        String canonicalHost = this.nodeId.canonical().host();
        String usedHost = this.nodeId.hostForNetworkConnections();
        map.put("node", canonicalHost);
        if (!usedHost.equals(canonicalHost)) {
            map.put("alt_node", usedHost);
        }
        if (this.bucket != null) {
            map.put("bucket", this.bucket);
        }
    }
}

