/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.sort;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.sort.CoreSearchFieldMissing;
import com.couchbase.client.core.api.search.sort.CoreSearchFieldMode;
import com.couchbase.client.core.api.search.sort.CoreSearchFieldType;
import com.couchbase.client.core.api.search.sort.CoreSearchSort;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.FieldSorting;
import com.couchbase.client.protostellar.search.v1.Sorting;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreSearchSortField
extends CoreSearchSort {
    private final String field;
    @Nullable
    private final CoreSearchFieldType type;
    @Nullable
    private final CoreSearchFieldMode mode;
    @Nullable
    private final CoreSearchFieldMissing missing;

    public CoreSearchSortField(String field, @Nullable CoreSearchFieldType type, @Nullable CoreSearchFieldMode mode, @Nullable CoreSearchFieldMissing missing, boolean descending) {
        super(descending);
        this.field = Validators.notNull(field, "Field");
        this.type = type;
        this.mode = mode;
        this.missing = missing;
    }

    @Override
    protected String identifier() {
        return "field";
    }

    @Override
    protected void injectParams(ObjectNode queryJson) {
        super.injectParams(queryJson);
        queryJson.put("field", this.field);
        if (this.type != null) {
            queryJson.put("type", this.type.value());
        }
        if (this.mode != null) {
            queryJson.put("mode", this.mode.value());
        }
        if (this.missing != null) {
            queryJson.put("missing", this.missing.value());
        }
    }

    @Override
    public Sorting asProtostellar() {
        FieldSorting.Builder builder = FieldSorting.newBuilder().setField(this.field).setDescending(this.descending);
        if (this.missing != null) {
            builder.setMissing(this.missing.value());
        }
        if (this.mode != null) {
            builder.setMode(this.mode.value());
        }
        if (this.type != null) {
            builder.setType(this.type.value());
        }
        return Sorting.newBuilder().setFieldSorting(builder).build();
    }
}

