/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.result;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchMetaData;
import com.couchbase.client.core.api.search.result.CoreSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchRow;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.List;
import java.util.Map;

@Stability.Internal
public class CoreSearchResult {
    private final List<CoreSearchRow> rows;
    private final CoreSearchMetaData meta;
    private final Map<String, CoreSearchFacetResult> facets;

    public CoreSearchResult(List<CoreSearchRow> rows, Map<String, CoreSearchFacetResult> facets, CoreSearchMetaData meta) {
        this.rows = rows;
        this.facets = facets;
        this.meta = meta;
    }

    public CoreSearchMetaData metaData() {
        return this.meta;
    }

    public List<CoreSearchRow> rows() {
        return this.rows;
    }

    public Map<String, CoreSearchFacetResult> facets() {
        return this.facets;
    }

    public String toString() {
        return "SearchResult{rows=" + RedactableArgument.redactUser(this.rows) + ", meta=" + RedactableArgument.redactMeta(this.meta) + ", facets=" + RedactableArgument.redactUser(this.facets) + '}';
    }
}

