/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.collector;

import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryRequestType;
import com.couchbase.client.core.cnc.apptelemetry.collector.FixedBucketLongHistogram;
import com.couchbase.client.core.cnc.apptelemetry.collector.Reportable;
import com.couchbase.client.core.util.CbCollections;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

class AppTelemetryHistogram
implements Reportable {
    private final String name;
    private final FixedBucketLongHistogram histogram;
    private final List<String> bucketNames;
    private final LongAdder totalMicros = new LongAdder();

    AppTelemetryHistogram(AppTelemetryRequestType type) {
        this(type.name, type.buckets);
    }

    private AppTelemetryHistogram(String name, List<Duration> bucketUpperBoundInclusive) {
        List<Long> bucketUpperBoundInclusiveNanos = CbCollections.transform(bucketUpperBoundInclusive, Duration::toNanos);
        bucketUpperBoundInclusiveNanos.add(Long.MAX_VALUE);
        this.name = Objects.requireNonNull(name);
        this.bucketNames = AppTelemetryHistogram.formatBucketNames(bucketUpperBoundInclusiveNanos);
        this.histogram = new FixedBucketLongHistogram(bucketUpperBoundInclusiveNanos);
    }

    void record(long nanos) {
        this.histogram.record(nanos);
        this.totalMicros.add(TimeUnit.NANOSECONDS.toMicros(nanos));
    }

    @Override
    public void reportTo(Consumer<? super CharSequence> charSink, Map<String, String> commonTags, long currentTimeMillisIgnored) {
        long[] buckets = this.histogram.report();
        long totalMillis = TimeUnit.MICROSECONDS.toMillis(this.totalMicros.sumThenReset());
        if (Arrays.stream(buckets).allMatch(it -> it == 0L)) {
            return;
        }
        AppTelemetryHistogram.cumulatize(buckets);
        String prefix = this.name + "_duration_milliseconds_";
        for (int i = 0; i < buckets.length; ++i) {
            String bucketName = this.bucketNames.get(i);
            long bucketValue = buckets[i];
            LinkedHashMap<String, @Nullable String> tags = new LinkedHashMap<String, String>();
            tags.put("le", bucketName);
            tags.putAll(commonTags);
            charSink.accept(prefix + "bucket" + AppTelemetryHistogram.formatTags(tags) + " " + bucketValue + "\n");
        }
        charSink.accept(prefix + "sum" + AppTelemetryHistogram.formatTags(commonTags) + " " + totalMillis + "\n");
        charSink.accept(prefix + "count" + AppTelemetryHistogram.formatTags(commonTags) + " " + buckets[buckets.length - 1] + "\n");
    }

    static String formatTags(Map<String, @Nullable String> tags) {
        return tags.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"").collect(Collectors.joining(",", "{", "}"));
    }

    private static List<String> formatBucketNames(List<Long> nanos) {
        return CbCollections.transform(nanos, it -> it == Long.MAX_VALUE ? "+Inf" : Long.toString(TimeUnit.NANOSECONDS.toMillis((long)it)));
    }

    private static void cumulatize(long[] values) {
        int len = values.length;
        for (int i = 1; i < len; ++i) {
            int n = i;
            values[n] = values[n] + values[i - 1];
        }
    }
}

