/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.query;

import com.couchbase.client.core.annotation.Stability;
import java.util.Objects;

@Stability.Internal
public class CoreQueryContext {
    private final String namespace;
    private final String bucket;
    private final String scope;

    private CoreQueryContext(String namespace, String bucket, String scope) {
        this.namespace = Objects.requireNonNull(namespace);
        this.bucket = Objects.requireNonNull(bucket);
        this.scope = Objects.requireNonNull(scope);
        if (namespace.contains("`") || bucket.contains("`") || scope.contains("`")) {
            throw new IllegalArgumentException("Query context components may not contain backticks");
        }
    }

    public static CoreQueryContext of(String bucket, String scope) {
        return new CoreQueryContext("default", bucket, scope);
    }

    public String format() {
        return this.namespace + ":`" + this.bucket + "`.`" + this.scope + "`";
    }

    public String bucket() {
        return this.bucket;
    }

    public String scope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreQueryContext that = (CoreQueryContext)o;
        return this.namespace.equals(that.namespace) && this.bucket.equals(that.bucket) && this.scope.equals(that.scope);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.bucket, this.scope);
    }

    public String toString() {
        return this.format();
    }
}

