/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.endpoint;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.EndpointState;
import java.time.Duration;

public class EndpointStateChangedEvent
extends AbstractEvent {
    private final EndpointState oldState;
    private final EndpointState newState;

    public EndpointStateChangedEvent(EndpointContext context, EndpointState oldState, EndpointState newState) {
        this((Context)context, oldState, newState);
    }

    public EndpointStateChangedEvent(Context context, EndpointState oldState, EndpointState newState) {
        super(Event.Severity.DEBUG, Event.Category.ENDPOINT, Duration.ZERO, context);
        this.oldState = oldState;
        this.newState = newState;
    }

    public EndpointState oldState() {
        return this.oldState;
    }

    public EndpointState newState() {
        return this.newState;
    }

    @Override
    public String description() {
        return "Endpoint changed state from " + (Object)((Object)this.oldState) + " to " + (Object)((Object)this.newState);
    }
}

