/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.CouchbaseThreadFactory;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@Stability.Internal
public class Jdk8Cleaner {
    private static final ThreadFactory cleanerThreadFactory = new CouchbaseThreadFactory("cb-cleaner-");
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final Set<CleanableImpl> references = Collections.newSetFromMap(new ConcurrentHashMap());
    static AtomicInteger activeCleanerThreadCount = new AtomicInteger();
    private final Thread thread;
    private final AtomicBoolean done = new AtomicBoolean();

    public static Jdk8Cleaner create(ThreadFactory factory) {
        return new Jdk8Cleaner(factory);
    }

    public static void registerWithOneShotCleaner(Object obj, Runnable cleanupTask) {
        Jdk8Cleaner cleaner = Jdk8Cleaner.create(cleanerThreadFactory);
        cleaner.register(obj, new OneShotCleanerAction(cleanupTask, cleaner.thread, cleaner.done));
    }

    private Jdk8Cleaner(ThreadFactory factory) {
        this.thread = factory.newThread(this::doRun);
        this.thread.start();
    }

    public Cleanable register(Object obj, Runnable cleaningAction) {
        CleanableImpl cleanable = new CleanableImpl(obj, this.queue, cleaningAction);
        this.references.add(cleanable);
        return cleanable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRun() {
        activeCleanerThreadCount.incrementAndGet();
        try {
            while (!this.done.get()) {
                try {
                    CleanableImpl r = (CleanableImpl)this.queue.remove();
                    this.references.remove(r);
                    r.clean();
                }
                catch (InterruptedException e) {
                    activeCleanerThreadCount.decrementAndGet();
                    return;
                }
            }
        }
        finally {
            activeCleanerThreadCount.decrementAndGet();
        }
    }

    private static class CleanableImpl
    extends PhantomReference<Object>
    implements Cleanable {
        private final Runnable cleaningAction;
        private final AtomicBoolean alreadyCleaned = new AtomicBoolean();

        CleanableImpl(Object referent, ReferenceQueue<Object> q, Runnable cleaningAction) {
            super(referent, q);
            this.cleaningAction = Objects.requireNonNull(cleaningAction);
        }

        @Override
        public void clean() {
            if (this.alreadyCleaned.compareAndSet(false, true)) {
                try {
                    this.cleaningAction.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static interface Cleanable {
        public void clean();
    }

    private static class OneShotCleanerAction
    implements Runnable {
        private final Runnable wrappedAction;
        private final Thread thread;
        private final AtomicBoolean done;

        public OneShotCleanerAction(Runnable wrappedAction, Thread thread, AtomicBoolean done) {
            this.wrappedAction = Objects.requireNonNull(wrappedAction);
            this.thread = Objects.requireNonNull(thread);
            this.done = Objects.requireNonNull(done);
        }

        @Override
        public void run() {
            try {
                this.wrappedAction.run();
            }
            finally {
                this.done.set(true);
                this.thread.interrupt();
            }
        }
    }
}

